% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{prevalenceAttrition}
\alias{prevalenceAttrition}
\title{Attrition associated with an prevalence analysis}
\usage{
prevalenceAttrition(result)
}
\arguments{
\item{result}{Result for which to get attrition}
}
\value{
tibble with counts and reasons for attrition.
}
\description{
Attrition associated with an prevalence analysis
}
\examples{
\donttest{
cdm <- mockIncidencePrevalenceRef(sampleSize = 200)
cdm <- generateDenominatorCohortSet(cdm, name = "denominator")
prev <- estimatePointPrevalence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome"
)
prevalenceAttrition(prev)
}
}
