/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.DenseFloatAlgebra;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.CGLSFloatIterationMonitor;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatIdentity;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatCGLS
extends AbstractFloatIterativeSolver {
    private static final DenseFloatAlgebra alg = DenseFloatAlgebra.DEFAULT;
    public static final float sqrteps = (float)Math.sqrt(Math.pow(2.0, -52.0));

    public FloatCGLS() {
        this.iter = new CGLSFloatIterationMonitor();
        ((CGLSFloatIterationMonitor)this.iter).setRelativeTolerance(-1.0f);
    }

    public FloatMatrix1D solve(FloatMatrix2D floatMatrix2D, FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) throws IterativeSolverFloatNotConvergedException {
        float f;
        float f2 = 0.0f;
        if ((double)((CGLSFloatIterationMonitor)this.iter).getRelativeTolerance() == -1.0) {
            ((CGLSFloatIterationMonitor)this.iter).setRelativeTolerance(sqrteps * alg.norm2(floatMatrix2D.zMult(floatMatrix1D, null, 1.0f, 0.0f, true)));
        }
        FloatMatrix1D floatMatrix1D3 = floatMatrix2D.zMult(floatMatrix1D2, null);
        floatMatrix1D3.assign(floatMatrix1D, FloatFunctions.plusMultFirst(-1.0f));
        FloatMatrix1D floatMatrix1D4 = floatMatrix2D.zMult(floatMatrix1D3, null, 1.0f, 0.0f, true);
        float f3 = alg.norm2(floatMatrix1D4);
        if (!(this.M instanceof FloatIdentity)) {
            floatMatrix1D4 = this.M.transApply(floatMatrix1D4, null);
            f = alg.norm2(floatMatrix1D4);
            f *= f;
        } else {
            f = f3;
            f *= f;
        }
        FloatMatrix1D floatMatrix1D5 = floatMatrix1D4.copy();
        this.iter.setFirst();
        while (!this.iter.converged(f3, floatMatrix1D2)) {
            FloatMatrix1D floatMatrix1D6;
            if (!this.iter.isFirst()) {
                float f4 = f / f2;
                floatMatrix1D5.assign(floatMatrix1D4, FloatFunctions.plusMultFirst(f4));
            }
            if (!(this.M instanceof FloatIdentity)) {
                floatMatrix1D4 = this.M.apply(floatMatrix1D5, null);
                floatMatrix1D6 = floatMatrix2D.zMult(floatMatrix1D4, null);
            } else {
                floatMatrix1D6 = floatMatrix2D.zMult(floatMatrix1D5, null);
            }
            float f5 = alg.norm2(floatMatrix1D6);
            f5 *= f5;
            float f6 = f / f5;
            if (!(this.M instanceof FloatIdentity)) {
                floatMatrix1D2.assign(floatMatrix1D4, FloatFunctions.plusMultSecond(f6));
            } else {
                floatMatrix1D2.assign(floatMatrix1D5, FloatFunctions.plusMultSecond(f6));
            }
            floatMatrix1D3.assign(floatMatrix1D6, FloatFunctions.plusMultSecond(-f6));
            floatMatrix1D4 = floatMatrix2D.zMult(floatMatrix1D3, null, 1.0f, 0.0f, true);
            f3 = alg.norm2(floatMatrix1D4);
            if (!(this.M instanceof FloatIdentity)) {
                floatMatrix1D4 = this.M.transApply(floatMatrix1D4, null);
                f2 = f;
                f = alg.norm2(floatMatrix1D4);
                f *= f;
            } else {
                f2 = f;
                f = f3;
                f *= f;
            }
            this.iter.next();
        }
        return floatMatrix1D2;
    }
}

