/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.DoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.jet.math.tdouble.DoubleFunctions;

public class DoubleBiCGstab
extends AbstractDoubleIterativeSolver {
    private DoubleMatrix1D p;
    private DoubleMatrix1D s;
    private DoubleMatrix1D phat;
    private DoubleMatrix1D shat;
    private DoubleMatrix1D t;
    private DoubleMatrix1D v;
    private DoubleMatrix1D temp;
    private DoubleMatrix1D r;
    private DoubleMatrix1D rtilde;

    public DoubleBiCGstab(DoubleMatrix1D doubleMatrix1D) {
        this.p = doubleMatrix1D.copy();
        this.s = doubleMatrix1D.copy();
        this.phat = doubleMatrix1D.copy();
        this.shat = doubleMatrix1D.copy();
        this.t = doubleMatrix1D.copy();
        this.v = doubleMatrix1D.copy();
        this.temp = doubleMatrix1D.copy();
        this.r = doubleMatrix1D.copy();
        this.rtilde = doubleMatrix1D.copy();
    }

    public DoubleMatrix1D solve(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) throws IterativeSolverDoubleNotConvergedException {
        this.checkSizes(doubleMatrix2D, doubleMatrix1D, doubleMatrix1D2);
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = 1.0;
        doubleMatrix2D.zMult(doubleMatrix1D2, this.r.assign(doubleMatrix1D), -1.0, 1.0, false);
        this.rtilde.assign(this.r);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, doubleMatrix1D2)) {
            d = this.rtilde.zDotProduct(this.r);
            if (d == 0.0) {
                throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Breakdown, "rho", this.iter);
            }
            if (d5 == 0.0) {
                throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Breakdown, "omega", this.iter);
            }
            if (this.iter.isFirst()) {
                this.p.assign(this.r);
            } else {
                d4 = d / d2 * (d3 / d5);
                this.temp.assign(this.v, DoubleFunctions.multSecond(-d5)).assign(this.p, DoubleFunctions.plus);
                this.p.assign(this.r).assign(this.temp, DoubleFunctions.plusMultSecond(d4));
            }
            this.M.apply(this.p, this.phat);
            doubleMatrix2D.zMult(this.phat, this.v);
            d3 = d / this.rtilde.zDotProduct(this.v);
            this.s.assign(this.r).assign(this.v, DoubleFunctions.plusMultSecond(-d3));
            if (this.iter.converged(this.s, doubleMatrix1D2)) {
                return doubleMatrix1D2.assign(this.phat, DoubleFunctions.plusMultSecond(d3));
            }
            this.M.apply(this.s, this.shat);
            doubleMatrix2D.zMult(this.shat, this.t);
            d5 = this.t.zDotProduct(this.s) / this.t.zDotProduct(this.t);
            doubleMatrix1D2.assign(this.phat, DoubleFunctions.plusMultSecond(d3));
            doubleMatrix1D2.assign(this.shat, DoubleFunctions.plusMultSecond(d5));
            this.r.assign(this.s).assign(this.t, DoubleFunctions.plusMultSecond(-d5));
            d2 = d;
            this.iter.next();
        }
        return doubleMatrix1D2;
    }
}

