/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.WrapperIntMatrix2D;

public class DenseLargeIntMatrix2D
extends WrapperIntMatrix2D {
    private static final long serialVersionUID = 1L;
    private int[][] elements;

    public DenseLargeIntMatrix2D(int n, int n2) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new int[n][n2];
        this.content = this;
    }

    public int getQuick(int n, int n2) {
        return this.elements[n][n2];
    }

    public void setQuick(int n, int n2, int n3) {
        this.elements[n][n2] = n3;
    }

    public int[][] elements() {
        return this.elements;
    }

    protected IntMatrix2D getContent() {
        return this;
    }

    public IntMatrix2D like(int n, int n2) {
        return new DenseLargeIntMatrix2D(n, n2);
    }

    public IntMatrix1D like1D(int n) {
        return new DenseIntMatrix1D(n);
    }
}

