/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;

public class FloatGivensRotation {
    private final float c;
    private final float s;

    public FloatGivensRotation(float f, float f2) {
        float f3 = Math.abs(f) > Math.abs(f2) ? f : f2;
        float f4 = Math.abs(f) + Math.abs(f2);
        if (f4 != 0.0f) {
            float f5 = f / f4;
            float f6 = f2 / f4;
            float f7 = f4 * (float)Math.sqrt(f5 * f5 + f6 * f6);
            if (f3 < 0.0f) {
                f7 *= -1.0f;
            }
            this.c = f / f7;
            this.s = f2 / f7;
        } else {
            this.c = 1.0f;
            this.s = 0.0f;
        }
    }

    public void apply(FloatMatrix2D floatMatrix2D, int n, int n2, int n3) {
        float f = this.c * floatMatrix2D.getQuick(n2, n) + this.s * floatMatrix2D.getQuick(n3, n);
        floatMatrix2D.setQuick(n3, n, -this.s * floatMatrix2D.getQuick(n2, n) + this.c * floatMatrix2D.getQuick(n3, n));
        floatMatrix2D.setQuick(n2, n, f);
    }

    public void apply(FloatMatrix1D floatMatrix1D, int n, int n2) {
        float f = this.c * floatMatrix1D.getQuick(n) + this.s * floatMatrix1D.getQuick(n2);
        floatMatrix1D.setQuick(n2, -this.s * floatMatrix1D.getQuick(n) + this.c * floatMatrix1D.getQuick(n2));
        floatMatrix1D.setQuick(n, f);
    }
}

