/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tdouble;

import cern.jet.random.tdouble.AbstractDiscreteDistribution;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;

public class Zeta
extends AbstractDiscreteDistribution {
    private static final long serialVersionUID = 1L;
    protected double ro;
    protected double pk;
    protected double c;
    protected double d;
    protected double ro_prev = -1.0;
    protected double pk_prev = -1.0;
    protected double maxlongint = 9.223372036854776E18;
    protected static Zeta shared = new Zeta(1.0, 1.0, Zeta.makeDefaultGenerator());

    public Zeta(double d, double d2, DoubleRandomEngine doubleRandomEngine) {
        this.setRandomGenerator(doubleRandomEngine);
        this.setState(d, d2);
    }

    protected long generateZeta(double d, double d2, DoubleRandomEngine doubleRandomEngine) {
        long l;
        if (d != this.ro_prev || d2 != this.pk_prev) {
            this.ro_prev = d;
            this.pk_prev = d2;
            if (d < d2) {
                this.c = d2 - 0.5;
                this.d = 0.0;
            } else {
                this.c = d - 0.5;
                this.d = (1.0 + d) * Math.log((1.0 + d2) / (1.0 + d));
            }
        }
        while (true) {
            double d3 = doubleRandomEngine.raw();
            double d4 = doubleRandomEngine.raw();
            double d5 = (this.c + 0.5) * Math.exp(-Math.log(d3) / d) - this.c;
            if (d5 <= 0.5 || d5 >= this.maxlongint) continue;
            l = (int)(d5 + 0.5);
            double d6 = -Math.log(d4);
            if (!(d6 < (1.0 + d) * Math.log(((double)l + d2) / (d5 + this.c)) - this.d)) break;
        }
        return l;
    }

    public int nextInt() {
        return (int)this.generateZeta(this.ro, this.pk, this.randomGenerator);
    }

    public void setState(double d, double d2) {
        this.ro = d;
        this.pk = d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int staticNextInt(double d, double d2) {
        Zeta zeta = shared;
        synchronized (zeta) {
            shared.setState(d, d2);
            return shared.nextInt();
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.ro + "," + this.pk + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(DoubleRandomEngine doubleRandomEngine) {
        Zeta zeta = shared;
        synchronized (zeta) {
            shared.setRandomGenerator(doubleRandomEngine);
        }
    }
}

