% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QAQC.R
\name{QAQC}
\alias{QAQC}
\title{QAQC}
\usage{
QAQC(file, writeQCreport = F, outfile_QAQC = "", summaryStats = T,
  dataReport = F, checkdoi = T, verbose = T)
}
\arguments{
\item{file}{File path for template file to be checked}

\item{writeQCreport}{If TRUE, a text report of the QC output will be written to the outfile. Default is FALSE}

\item{outfile_QAQC}{Filename of the output file (if writeQCreport==TRUE). Default is NULL, with the outfile being written to the directory where the template file is stored and named according to the file being checked.}

\item{summaryStats}{Prints summary statistics. Default is TRUE.}

\item{dataReport}{Prints list structure of database. Default is FALSE.}

\item{checkdoi}{Set to FALSE if you do not want the QAQC check to validate DOIs (if TRUE this will be time consuming). Default is TRUE.}

\item{verbose}{Set to TRUE to print results of function to console. Default is TRUE.}
}
\description{
Checks template files for data coherence, formatting, and data entry errors
}
\details{
This function can also be called from the ISRaD website (<http://soilradiocarbon.org>).
}
\examples{
\donttest{
# Load example dataset Gaudinski_2001
database <- ISRaD::Gaudinski_2001
# Save as .xlsx file
ISRaD.save.xlsx(database = database,
 template_file = system.file("extdata", "ISRaD_Master_Template.xlsx", package = "ISRaD"),
 outfile = paste0(tempdir(),"/Gaudinski_2001.xlsx"))
# Run QAQC
QAQC(paste0(tempdir(),"/Gaudinski_2001.xlsx"))
}
}
