#' Acceleration
#'
#' Dataset with acceleration target value w.r.t. 14 nominal and numerical variables
#'
#' @docType data
#'
#' @usage data(accel)
#'
#' @format A \code{"data.frame"} structure with 1732 observations, 3 nominal and 11 numerical predictor variables
#'
#' @keywords datasets
#'
#' @references Hadi Fanaee-T. and João Gama. Event labeling combining ensemble detectors and background knowledge. Prog. in Art. Int., pages 1-15, 2013. ISSN 2192-6352. (\href{https://link.springer.com/article/10.1007/s13748-013-0040-3}{Springer})
#'
#' @source \href{https://archive.ics.uci.edu/ml/datasets/bike+sharing+dataset}{UCI Archive}
#'
#' @aliases accel
#'
#' @examples
#' data(accel)
#' head(accel)
"accel"


#' NO2Emissions
#'
#' The data are a subsample of 500 observations from a data set that originate in a study where air pollution at a road is
#' related to traffic volume and meteorological variables, collected by the Norwegian Public Roads Administration.
#' The response variable (column 1) consist of hourly values of the logarithm of the concentration of NO2 (particles),
#' measured at Alnabru in Oslo, Norway, between October 2001 and August 2003. The predictor variables (columns 2 to 8)
#' are the logarithm of the number of cars per hour, temperature $2$ meter above ground (degree C), wind speed
#' (meters/second), the temperature difference between $25$ and $2$ meters above ground (degree C),
#' wind direction (degrees between 0 and 360), hour of day and day number from October 1. 2001.
#'
#' @docType data
#'
#' @usage data(NO2Emissions)
#'
#' @format A \code{"data.frame"} structure with 500 observations, 8 numerical variables
#'
#' @keywords datasets
#'
#' @source \href{http://lib.stat.cmu.edu/datasets/}{StatLib}
#'
#' @aliases NO2Emissions
#'
#' @examples
#' data(NO2Emissions)
#' head(NO2Emissions)
"NO2Emissions"
