% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/itemfit.R
\name{orlando_itemf}
\alias{orlando_itemf}
\title{Orlando's statistic}
\usage{
orlando_itemf(patterns, G, zita, model)
}
\arguments{
\item{patterns}{matrix of patterns response, the frequency of each pattern and the latent traits}

\item{G}{number of quadrature Points}

\item{zita}{matrix of estimations of the parameters of the items (discrimination,difficulty, guessing)}

\item{model}{type of model ( "1PL", 2PL", "3PL" )}
}
\value{
Orlando's statistic, degrees of freedom and pvalue for each item
}
\description{
calculates the S-X2 values from Maria Orlando and David Thisen.
}
\examples{
#Simulates a test and returns a list:
test=simulateTest()

#the simulated data:
data=test$test

#model:
mod=irtpp(dataset = data,model = "3PL")
#Convert parameters to a matrix
zz = parameter.matrix(mod$z,byrow = FALSE)
#Estimating Latent Traits
p_mat=mod$prob_mat
trazos = individual.traits(model="3PL", itempars = zz,method = "EAP",dataset = data,
probability_matrix=p_mat)
#Z3 PERSONFIT-Statistic
orlando_itemf(patterns = as.matrix(trazos),G = 61,zita = mod$z,model = "3PL")
}
\author{
SICS Research, National University of Colombia \email{ammontenegrod@unal.edu.co}
}
\references{
Orlando, M. & Thissen, D. (2000). Likelihood-based item fit indices for dichotomous item
response theory models. \emph{Applied Psychological Measurement, 24}, 50-64.
}
\seealso{
\code{\link{z3_itemf}}, \code{\link{x2_itemf}}
}

