
# # #####################################################################################################################
context("testing package installation")
test_that("testing package installation", {
  expect_identical(checkLoadPackages("config"),0)
  expect_identical(checkLoadPackages("valueEQ5D"),0)
  expect_identical(suppressWarnings(checkLoadPackages("this")),-1)
  expect_identical(suppressWarnings(checkLoadPackages("sheeja")),-1)
})
# # #####################################################################################################################
context("testing file existence")
test_that("test for file existence and access", {
  thisfile=system.file("extdata", "blank.txt", package = "IPDFileCheck")
  expect_identical(testFileExistenceReadability(thisfile),0)
  nofile=system.file("extdata", "read.txt", package = "IPDFileCheck")
  expect_identical(suppressWarnings(testFileExistenceReadability(nofile)),-1)
})

# #####################################################################################################################
context("testing column names of a data")
test_that("testing column names of a data", {
  x <- c("F","M","cvb","sheeja")
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("num","name")
  expect_identical(testDataColumnNames(c("num","name"),tempdata),0)
  colnames(tempdata)<-c("num","sex")
  expect_identical(suppressWarnings(testDataColumnNames(c("num","name"),tempdata)),-1)
})
# #  # #####################################################################################################################

context("testing age calculated from year of birth")
test_that("testing age calculated from year of birth", {
  x <- c("1957","1987",NA,"1989")
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","dob")
  ag1=as.numeric(format(Sys.Date(), "%Y"))-1957
  ag2=as.numeric(format(Sys.Date(), "%Y"))-1987
  ag3=as.numeric(format(Sys.Date(), "%Y"))-1989
  ages<-c(ag1,ag2,NA,ag3)
  mod.data<-calculateAgeFromBirthYear(tempdata,"dob",NA)$calc.age.yob
  expect_equivalent(ages,mod.data,tolerance = 0.001)
  x <- c(1957,1987,NA,1989)
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","dob")
  expect_equivalent(ages,mod.data,tolerance = 0.001)
  colnames(tempdata)<-c("name","date")
  expect_identical(suppressWarnings(calculateAgeFromBirthYear(tempdata,"dob",NA)),-1)
  x <- c(1957,1987,1800,1989)
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","dob")
  expect_identical(suppressWarnings(calculateAgeFromBirthYear(tempdata,"dob",NA)),-2)
})
#  # #####################################################################################################################
context("testing age")
test_that("test for age checks for valid age", {
  x <- c(0,11,NA,120)
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","age")
  expect_identical(testAge(tempdata),0)
  x <- c(0,11,78,160)
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","age")
  expect_identical(suppressWarnings(testAge(tempdata,"age","")),-2)
  x <- c(0,11,78,160)
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","AGE")
  expect_identical(suppressWarnings(testAge(tempdata,"AGE")),-2)
  # #
  x <- c(-8, 99,2,5,-99)
  y <- c(1,2,3,4,5)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","age")
  expect_identical(suppressWarnings(testAge(tempdata,-99)),-1)
  colnames(tempdata)<-c("name","sex")
  expect_identical(suppressWarnings(testAge(tempdata,-99)),-1)
  #
  x <- c(0,11.5,"",120, "noresponse")
  y <- c(1,2,3,4,5)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","AGE")
  expect_identical(testAge(tempdata,"AGE","noresponse"),0)
  #
  x <- c(0,11.5,"",120, "noresponse")
  y <- c(1,2,3,4,5)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","age")
  expect_identical(suppressWarnings(testAge(tempdata,"years","noresponse")),-1)
})
#####################################################################################################################
context("testing gender")
test_that("test for gender checks for correct gender", {
  x <- c('F', 'M','m','M')
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","sex")
  # warning binrcpp versiion) appeared and suppressing it
  expect_identical(suppressWarnings(testGender(tempdata,c("f","m"),"sex")),0)
  x <- c('f', 'f','f','f',99)
  y <- c(1,2,3,4,5)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","gender")
  expect_identical(suppressWarnings(testGender(tempdata,c("f","m",99),"gender",99)),0)
  x <- c('f', 'f','m','m',99)
  y <- c(1,2,3,4,5)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","gender")
  expect_identical(testGender(tempdata,c("f","m",99),"gender",99),0)
  colnames(tempdata)<-c("name","age")
  expect_identical(suppressWarnings(testGender(tempdata,c("f","m",99),"sex",99)),-1)
  colnames(tempdata)<-c("name","sex")
  expect_identical(suppressWarnings(testGender(tempdata,c(1,2),"sex",99)),-2)
  x <- c('f', 'f','male','m',99)
  y <- c(1,2,3,4,5)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","gender")
  expect_identical(suppressWarnings(testGender(tempdata,c("f","m",99),"gender",99)),-2)
  x <- c('female', 'fEMALe','male','MALE',99)
  y <- c(1,2,3,4,5)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","gender")
  expect_identical(suppressWarnings(testGender(tempdata,c("female","male",99),"gender",99)),0)
})
# # # # #####################################################################################################################
context("testing column contents")
test_that("test column contents", {
  x <- c('f', 'm','m','m')
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","sex")
  expect_identical(testColumnContents(tempdata,"sex",c("f","m")),0)
  x <- c('m', 'u','m','u',99)
  y <- c(1,2,3,4,5)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","status")
  expect_identical(testColumnContents(tempdata,"status",c("m","u",99),99),0)
  colnames(tempdata)<-c("name","age")
  expect_identical(suppressWarnings(testColumnContents(tempdata,"sex",c("f","M"),99)),-1)
  x <- c(1,2,3,4,1,3,99)
  y <- c(1,2,3,4,5,6,7)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","level")
  expect_identical(testColumnContents(tempdata,"level",c(1,2,3,4,5),99),0)
  expect_identical(suppressWarnings(testColumnContents(tempdata,"level",c(1,2,3),99)),-2)
})
# # # #####################################################################################################################
context("testing the column number for column name")
test_that("test for sex checks for correct gender", {
  x <- c('F', 'Female','m','mALE')
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","sex")
  expect_equal(getColumnNoForNames(tempdata,"sex"),2)
  x <- c('F', 'Female','m','mALE',99)
  y <- c(1,2,3,4,5)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","gender")
  expect_identical(suppressWarnings(getColumnNoForNames(tempdata,"sex")),-1)
  colnames(tempdata)<-c("name","age")
  expect_equal(getColumnNoForNames(tempdata,"age"),2)
})
# # #   #####################################################################################################################
context("testing numeric column")
test_that("test for numeric values in a specific column", {
  x <- c(0,11,78,120)
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","dose")
  expect_identical(testDataNumeric("dose",tempdata,0,0,200),0)
  x <- c(-8, 99,2,5,-99)
  y <- c(1,2,3,4,5)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","dose")
  expect_identical(suppressWarnings(testDataNumeric("dose",tempdata,-99,0,200)),-2)

  x <- c("sheeja", 99,2,5,-99)
  y <- c(1,2,3,4,5)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","dose")
  expect_identical(suppressWarnings(testDataNumeric("dose",tempdata,-99,0,200)),-3)
  #
  colnames(tempdata)<-c("name","sex")
  expect_identical(suppressWarnings(testDataNumeric("dose",tempdata,-99,0,200)),-1)
})
# # # #####################################################################################################################
context("testing numeric column")
test_that("test for numeric values in a specific column but with no range given", {
  x <- c(0,11,78,120)
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","dose")
  expect_identical(testDataNumericNorange("dose",tempdata,0),0)
  x <- c(-8, 99,2,5,-99)
  y <- c(1,2,3,4,5)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","dose")
  expect_identical(testDataNumericNorange("dose",tempdata,-99),0)
  x <- c("sheeja", 99,2,5,-99)
  y <- c(1,2,3,4,5)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","dose")
  expect_identical(suppressWarnings(testDataNumericNorange("dose",tempdata,-99)),-2)
  colnames(tempdata)<-c("name","sex")
  expect_identical(suppressWarnings(testDataNumericNorange("dose",tempdata,-99)),-1)
})
# #####################################################################################################################

context("testing string column with restriction on allowed entries")
test_that("test for string values in a specific column", {
  x <- c("F","M","cvb","sheeja")
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("num","name")
  expect_identical(suppressWarnings(testDataStringRestriction(tempdata,"name",0,c("F","M"))),-2)
  x <- c("F","M","m","m")
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("num","name")
  expect_identical(testDataStringRestriction(tempdata,"name",0,c("F","M")),0)
  expect_identical(testDataStringRestriction(tempdata,"name",NA,c("F","M")),0)
  expect_identical(suppressWarnings(testDataStringRestriction(tempdata,"name",NA,c())),-3)

  colnames(tempdata)<-c("num","sex")
  expect_identical(suppressWarnings(testDataStringRestriction(tempdata,"name",-99,c())),-4)
  x <- c("F","M",100,"m")
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("num","name")
  expect_identical(suppressWarnings(testDataStringRestriction(tempdata,"name",0,c("F","M"))),-5)

})
# # # #####################################################################################################################
context("testing string column")
test_that("test for string values in a specific column", {
  x <- c("F","M","cvb","sheeja")
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("num","name")
  suppressWarnings(expect_identical(testDataString(tempdata,"name",0),0))
  suppressWarnings(expect_identical(testDataString(tempdata,"name","NA"),0))
  x <- c("F","M","cvb",-99)
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("num","name")
  suppressWarnings(expect_identical(testDataString(tempdata,"name",-99),0))
  x <- c("F","M","cvb",NA)
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("num","name")
  suppressWarnings(expect_identical(testDataString(tempdata,"name",-99),0))
  x <- c("F","M",100,NA)
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("num","name")
  expect_identical(suppressWarnings(testDataString(tempdata,"name",-99)),-2)
  colnames(tempdata)<-c("num","sex")
  expect_identical(suppressWarnings(testDataString(tempdata,"name",-99)),-1)
})

# # #####################################################################################################################
context("testing part of columnmames")
test_that("testing part of columnmames", {
  x <- c("F","M","cvb","sheeja")
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("num.x","name_x")
  expect_equal(getColumnNoForPatternInColumnname("name",colnames(tempdata)),2)
  colnames(tempdata)<-c("num.x","name_x")
  expect_equal(suppressWarnings(getColumnNoForPatternInColumnname("sex",colnames(tempdata))),-2)
  expect_equal(suppressWarnings(getColumnNoForPatternInColumnname("",colnames(tempdata))),-1)
  colnames(tempdata)<-c("num.x","num_x")
  expect_equal(getColumnNoForPatternInColumnname("num",colnames(tempdata)),c(1,2))
})
# # #####################################################################################################################
context("testing descriptive statistics")
test_that("testing descriptive statistics", {
  x <- c(0,11,78,160)
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","age")
  results=matrix(c(249,62.25,73.72189,44.5,0,36.86,0,160,4,8.25,98.5, 0.825,153.85),nrow=1, byrow=TRUE)
  colnames(results)<-c("Sum","Mean","SD","Median", "Mode","SE","Minimum","Maximum","Count","LQ","UQ", "95%CI.low", "95%CI.high")
  rownames(results)<-"age"
  expect_equal(descriptiveStatisticsDataColumn(tempdata,"age",NA),results,tolerance=0.001)
  descriptiveStatisticsDataColumn(tempdata,"age",NA)
})

context("testing descriptive statistics")
test_that("testing descriptive statistics", {
  x <- c(0,11,78,160)
  y <- c(1,2,3,4)
  tempdata= as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","age")
  results=matrix(c(249, 83,74.62573, 78,11,43.08519, 11 ,160 ,3,44.5,119 , 14.35, 155.9),nrow=1, byrow=TRUE)
  colnames(results)<-c("Sum","Mean","SD","Median", "Mode","SE","Minimum","Maximum","Count","LQ","UQ", "95%CI.low", "95%CI.high")
  rownames(results)<-"age"
  expect_equal(descriptiveStatisticsDataColumn(tempdata,"age",0),results,tolerance=0.001)
})

context("testing descriptive statistics")
test_that("testing descriptive statistics", {
  x <- c(0,NA,78,160)
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","age")
  results=matrix(c(238,79.33333,80.00833,78,0, 46.19283,0 ,160 ,3,39,119, 3.9,155.9),nrow=1, byrow=TRUE)
  colnames(results)<-c("Sum","Mean","SD","Median", "Mode","SE","Minimum","Maximum","Count","LQ","UQ", "95%CI.low", "95%CI.high")
  rownames(results)<-"age"
  expect_equal(descriptiveStatisticsDataColumn(tempdata,"age",NA),results,tolerance=0.001)
})

context("testing descriptive statistics")
test_that("testing descriptive statistics", {
  x <- c(0,NA,"dd",160)
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","age")
  expect_equal(suppressWarnings(descriptiveStatisticsDataColumn(tempdata,"age",NA)),-1)

})
context("testing descriptive statistics")
test_that("testing descriptive statistics", {
  x <- c(0,11,78,160)
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","dose")
  expect_equal(suppressWarnings(descriptiveStatisticsDataColumn(tempdata,"age",NA)),-2)
})
# # # #####################################################################################################################
context("testing mode function")
test_that("testing mode function", {
  x <- c(0,11,78,160)
  expect_equal(getModeForVector(x),0)
})
context("testing mode function")
test_that("testing mode function", {
  x <- c(0,"f",78,160)
  expect_equal(suppressWarnings(getModeForVector(x)),-1)
})
context("testing mode function")
test_that("testing mode function", {
  x <- c(78,NA,78,78)
  expect_equal(getModeForVector(x),78)
})
context("testing mode function")
test_that("testing mode function", {
  x <- c(78,"NA",78,78)
  expect_equal(suppressWarnings(getModeForVector(x)),-1)
})

# # # #####################################################################################################################
context("testing column existence")
test_that("testing column existence", {
  x <- c(0,NA,"dd",160)
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","age")
  expect_equal(checkColumnExists("age",tempdata),0)
})
context("testing column existence")
test_that("testing column existence", {
  x <- c(0,NA,"dd",160)
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","num")
  expect_equal(suppressWarnings(checkColumnExists("age",tempdata)),-1)
})
# # # #####################################################################################################################
context("testing -present mean and sd as mean(sd)")
test_that("testing -present mean and sd as mean(sd)", {
  x <- c(0,11,78,160)
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","num")
  answer= "62.25 (73.72)"
  expect_equal(presentMeanSdRemoveNAText(tempdata,"num",NA),answer)
})
context("testing -present mean and sd as mean(sd)")
test_that("testing -present mean and sd as mean(sd)", {
  x <- c(0,11,78,160,NA)
  y <- c(1,2,3,4,5)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","num")
  answer= "62.25 (73.72)"
  expect_equal(presentMeanSdRemoveNAText(tempdata,"num",NA),answer)
})
context("testing -present mean and sd as mean(sd)")
test_that("testing -present mean and sd as mean(sd)", {
  x <- c(0,11,78,160,NA,"NR")
  y <- c(1,2,3,4,5,6)
  tempdata = as.data.frame(cbind(y,x))
  colnames(tempdata)<-c("name","num")
  expect_equal(suppressWarnings(presentMeanSdRemoveNAText(tempdata,"num","NR")),-1)
})
# # # #####################################################################################################################
context("testing returning a subgroup omitting NA")
test_that("testing returning a subgroup omitting NA", {
  x <- c(0,11,78,160)
  y1 <- c("f","m","f","m")
  y2 <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y2,y1,x))
  colnames(tempdata)<-c("num","gender","mark")
  subgp=tempdata[tempdata$gender=="f"&!is.na(tempdata$gender),]
  expect_equal(returnSubgroupOmitNA(tempdata,"gender","f"),subgp)
})
context("testing returning a subgroup omitting NA")
test_that("testing returning a subgroup omitting NA", {
  x <- c(0,11,78,160)
  y1 <- c("f",NA,"f","m")
  y2 <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y2,y1,x))
  colnames(tempdata)<-c("num","gender","mark")
  subgp=tempdata[tempdata$gender=="f"&!is.na(tempdata$gender),]
  expect_equal(returnSubgroupOmitNA(tempdata,"gender","f"),subgp)
})
context("testing returning a subgroup omitting NA")
test_that("testing returning a subgroup omitting NA", {
  x <- c(0,11,78,160)
  y1 <- c("f",NA,"f","m")
  y2 <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y2,y1,x))
  colnames(tempdata)<-c("num","desc","mark")
  expect_equal(suppressWarnings(returnSubgroupOmitNA(tempdata,"gender","f")),-1)
})
# # # #####################################################################################################################
context("testing representing categorical data")
test_that("testing representing categorical data", {
  x <- c(0,11,78,160)
  y1 <- c("f","m","f","m")
  y2 <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y2,y1,x))
  colnames(tempdata)<-c("num","gender","mark")
  ans=c(2,50,2,50)
  expect_equal(representCategoricalData(tempdata,"gender",NA),ans)
  colnames(tempdata)<-c("num","a","mark")
  expect_equal(suppressWarnings(representCategoricalData(tempdata,"gender",NA)),-1)
})
# # # #####################################################################################################################
context("testing cohens d")
test_that("testing cohens d", {
  x <- c(0,11,78,160)
  y <- c(1,2,3,4)
  g1mean=mean(x)
  g2mean=mean(y)
  sdpooled=sqrt((sd(x)^2+sd(y)^2)/2)
  ans=abs(g2mean-g1mean)/sdpooled
  res=cohensD(x,y)[1]
  expect_equal(res,ans)
  x <- c(0,11,78,NA)
  expect_equal(suppressWarnings(cohensD(x,y)),-1)
  x <- c(0,11,78,"sh")
  expect_equal(suppressWarnings(cohensD(x,y)),-1)
})
# # # #####################################################################################################################
context("testing standard error of mean function")
test_that("testing standard error of mean function", {
  x <- c(0,11,78,160)
  semhere<-sd(x)/sqrt(length(x))
  res=getSEM(x)
  expect_equal(res,semhere)
  x <- c(0,11,78,"sh")
  expect_equal(suppressWarnings(getSEM(x)),-1)
  x <- c(0,11,78,"160")
  expect_equal(res,semhere)
})
# # # ## #####################################################################################################################
context("testing age calculated from date of birth")
test_that("testing age calculated from date of birth",{
  #x <- c("1987/05/28","1987/06/18",0,"1987/07/09")
  x <- c("1987-05-28","1987-06-18",0,"1987-07-09")
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x),stringsAsFactors = FALSE)
  colnames(tempdata)<-c("name","dob")
  ag1=eeptools::age_calc(as.Date("1987-05-28"), units='years')
  ag2=eeptools::age_calc(as.Date("1987-06-18"), units='years')
  ag3=eeptools::age_calc(as.Date("1987-07-09"), units='years')
  ages<-c(ag1,ag2,0,ag3)
  mod.data<-calculateAgeFromDob(tempdata,"dob",0,0)$calc.age.dob
  expect_equivalent(ages,mod.data,tolerance = 0.001)

  x <- c("1287-05-28","1987-06-18",NA,"1987-07-09")
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x),stringsAsFactors = FALSE)
  colnames(tempdata)<-c("name","dob")
  expect_equal(suppressWarnings(calculateAgeFromDob(tempdata,"dob",0,NA)),-3)


  x <- c("1987-05-28","1987-06-18",NA,"1987-07-09")
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x),stringsAsFactors = FALSE)
  colnames(tempdata)<-c("name","dob")
  mod.data<-calculateAgeFromDob(tempdata,"dob","%y-%m-%d",NA)$calc.age.dob
  ages<-c(ag1,ag2,NA,ag3)
  expect_equivalent(ages,mod.data,tolerance = 0.001)

  x <- c("1987-05-28","1987-06-18",NA,"1987-07-09")
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x),stringsAsFactors = FALSE)
  colnames(tempdata)<-c("name","dob")
  mod.data<-calculateAgeFromDob(tempdata,"dob",0,NA)$calc.age.dob
  ages<-c(ag1,ag2,NA,ag3)
  expect_equivalent(ages,mod.data,tolerance = 0.001)


  x <- c("28/05/1987","18/06/1987",NA,"9/7/1987")
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x),stringsAsFactors = FALSE)
  colnames(tempdata)<-c("name","dob")
  # debug(calculateAgeFromDob)
  # debug(convertStdDateFormat)
  mod.data<-calculateAgeFromDob(tempdata,"dob","%d/%m/%y",NA)$calc.age.dob
  ages<-c(ag1,ag2,NA,ag3)
  expect_equivalent(ages,mod.data,tolerance = 0.001)

  x <- c("05/28/1987","06/18/1987",NA,"7/9/1987")
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x),stringsAsFactors = FALSE)
  colnames(tempdata)<-c("name","dob")
  mod.data<-calculateAgeFromDob(tempdata,"dob","%m/%d/%y",NA)$calc.age.dob
  ages<-c(ag1,ag2,NA,ag3)
  expect_equivalent(ages,mod.data,tolerance = 0.001)


  x <- c("1997-05-28","1987-06-18",NA,"2015-07-09")
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x),stringsAsFactors = FALSE)
  colnames(tempdata)<-c("name","dob")
  ag1=eeptools::age_calc(as.Date("1997-05-28"), units='years')
  ag2=eeptools::age_calc(as.Date("1987-06-18"), units='years')
  ag3=eeptools::age_calc(as.Date("2015-07-09"), units='years')
  ages<-c(ag1,ag2,NA,ag3)
  mod.data<-calculateAgeFromDob(tempdata,"dob",0,NA)$calc.age.dob
  expect_equivalent(ages,mod.data,tolerance = 0.001)

  x <- c("1997 May 28","1987-June-18",NA,"2015/July/09")
  y <- c(1,2,3,4)
  tempdata = as.data.frame(cbind(y,x),stringsAsFactors = FALSE)
  colnames(tempdata)<-c("name","dob")
  expect_equivalent(suppressWarnings(calculateAgeFromDob(tempdata,"dob",0,NA)), -2)

  colnames(tempdata)<-c("name","date")
  expect_identical(suppressWarnings(calculateAgeFromDob(tempdata,"dob",0,NA)),-1)
})
