% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSet.R, R/DataSetList.R
\name{get_PAR_summary}
\alias{get_PAR_summary}
\alias{get_PAR_summary.DataSet}
\alias{get_PAR_summary.DataSetList}
\title{Get Parameter Value Summary}
\usage{
get_PAR_summary(ds, idxValue, ...)

\method{get_PAR_summary}{DataSet}(ds, idxValue, parId = "all",
  which = "by_FV", ...)

\method{get_PAR_summary}{DataSetList}(ds, idxValue, algorithm = "all",
  ...)
}
\arguments{
\item{ds}{A DataSet or DataSetList object}

\item{idxValue}{A Numerical vector. Index values at which parameter values are observed.
The index value can either take its value in the range of running times, or function values.
Such a value type is signified by `which` parameter.}

\item{...}{Arguments passed to other methods}

\item{parId}{A character vector. Either 'all' or the name of parameters to be retrieved}

\item{which}{A string takes values in `c('by_FV', 'by_RT')`, indicating the parameters to be
retrieved are aligned against the running time (RT) or function value (FV). `'by_FV'`
is the default value.}

\item{algorithm}{Which algorithms in the DataSetList to consider.}
}
\value{
A data.table object containing basic statistics of parameter values aligned at each given target value
}
\description{
Get Parameter Value Summary
}
\examples{
get_PAR_summary(dsl, 14)
get_PAR_summary(dsl[[1]], 14)
}
