% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INDperform.R
\docType{package}
\name{INDperform-package}
\alias{INDperform}
\alias{INDperform-package}
\title{INDperform: Performance validation of ecological state indicators}
\description{
INDperform provides an implementation of the 7-step approach suggested by
Otto \emph{et al.} (2018) to validate ecological state indicators
and to select a suite of complimentary and well performing indicators.
This suite can be then used to assess the current state of the system
in comparison to a reference period.
}
\details{
The package builds upon the tidy data principles and offers functions to
\itemize{
  \item identify temporal indicator changes,
  \item model relationships to pressures while taking non-linear responses
        and temporal autocorrelation into account, and to
  \item quantify the robustness of these models.
}

These functions can be executed on any number of indicators and pressures.
Based on these analyses and a scoring scheme for selected criteria the
individual performances can be quantified, visualized, and compared. The
combination of tools provided in this package can significantly help making
state indicators operational under given management schemes such as the
EU Marine Strategy Framework Directive.
}
\section{Usage}{

INDperform offers function that can be applied individually to some
extent but mostly build upon each other to follow the 7-step approach.
They can be grouped into 3 broad categories. For demonstration purposes
the package provides a dataset of food web indicators and pressure
variables in the Central Baltic Sea (modified from Otto \emph{et al.},
2018).
}

\section{1. Validation of IND performances}{

The following functions implement the first five steps of the 7-step
validation approach and model each IND as a function of time or a
single pressure variable using Generalized Additive Models (GAMs)
(based on the \code{\link{mgcv}} package):
\itemize{
  \item \code{\link{model_trend}}
  \item \code{\link{ind_init}}
  \item \code{\link{model_gam}}
  \item \code{\link{model_gamm}}
  \item \code{\link{select_model}}
  \item \code{\link{merge_models}}
  \item \code{\link{calc_deriv}}
  \item \code{\link{select_interaction}}
  \item \code{\link{test_interaction}}
}

To show the model diagnostics or complete model results use the functions:
\itemize{
  \item \code{\link{plot_diagnostics}}
  \item \code{\link{plot_trend}}
  \item \code{\link{plot_model}}
}
}

\section{2. Scoring IND performance based on model output}{

Among the 16 common indicator selection criteria, five criteria relate
to the indicators` performances and require time series for their
evaluation, i.e.

8. Development reflects ecosystem change caused by variation in
 manageable pressure(s)

9. Sensitive or responsive to pressures

10. Robust, i.e. responses in a predictive fashion, and statistically sound

11. Links to management measures (responsiveness and specificity)

12. Relates where appropriate to other indicators but is not redundant

In this package, the scoring scheme for these criteria as proposed by
Otto \emph{et al.} (2018) serves as basis for the quantification
of the IND performance (see the scoring template table
\code{\link{crit_scores_tmpl}}). Sensitivity (criterion 9) and
robustness (criterion 10) are specified into more detailed sub-criteria
to allow for quantification based on statistical models and rated
individually for every potential pressure that might affect the IND
directly or indirectly.

However, the scoring template can easily be adapted to any kind of state
indicator and management scheme by modifying the scores, the weighting
of scores or by removing (sub)criteria.

The following functions relate to the indicator performance scoring
(used in this order):
\itemize{
  \item \code{\link{scoring}}
  \item \code{\link{expect_resp}}
  \item \code{\link{summary_sc}}
  \item \code{\link{plot_spiechart}}
}

For examining redundancies and selecting robust indicator suites use
(in that order):
\itemize{
  \item \code{\link{dist_sc}}
  \item \code{\link{clust_sc}}
  \item \code{\link{plot_clust_sc}}
}
}

\section{3. Assessment of current state status}{

Two approaches based on trajectories in state space to determine
the current state of the system in comparison to an earlier period
as reference using the selected IND suite (state space =
n-dimensional space of possible locations of IND variables)

1. Calculation of the Euclidean distance in state space of any
dimensionality between each single year (or any other time step
used) and a defined reference year:
\itemize{
  \item \code{\link{statespace_ed}}
  \item \code{\link{plot_statespace_ed}}
}

2. Given the identification of a reference domain in state space,
more recent observations might lie within or outside this domain.
The convex hull is a multivariate measure derived from
computational geometry representing the smallest convex set
containing all the reference points in Euclidean plane or space.
For visualization, only 2 dimensions considered (dimension
reduction through e.g. Principal Component Analysis suggested).
\itemize{
  \item \code{\link{statespace_ch}}
  \item \code{\link{plot_statespace_ch}}
}
}

\references{
To learn more about the framework, see

Otto, S.A., Kadin, M., Casini, M., Torres, M.A., Blenckner, T. (2018)
A quantitative framework for selecting and validating food web indicators.
\emph{Ecological Indicators}, 84: 619-631,
doi: https://doi.org/10.1016/j.ecolind.2017.05.045
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/saskiaotto/INDperform}
  \item Report bugs at \url{https://github.com/SaskiaAOtto/INDperform/issues}
}

}
\author{
\strong{Maintainer}: Saskia A. Otto \email{saskia.a.otto@gmail.com}

Authors:
\itemize{
  \item Rene Plonus
  \item Steffen Funk
  \item Alexander Keth
}

}
