% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_scores.R
\name{aggregate_scores}
\alias{aggregate_scores}
\title{Aggregate deprivation scores}
\usage{
aggregate_scores(
  data,
  score_col,
  rank_col,
  decile_col,
  higher_level_geography,
  population
)
}
\arguments{
\item{data}{Data frame containing a variable to be aggregated, lower level
geography population estimates, and a higher level geographical
grouping variable}

\item{score_col}{Variable containing deprivation scores}

\item{rank_col}{Variable containing deprivation ranks}

\item{decile_col}{Variable containing deprivation deciles}

\item{higher_level_geography}{Name of the variable in the data frame
containing the higher level geography names/codes}

\item{population}{Name of the variable in the data frame containing
the population estimates of the lower level geography}
}
\value{
A tibble containing population-weighted average scores,
    proportions of highly deprived areas, and the extent for
    the higher-level geography.
}
\description{
Aggregate deprivation scores into higher-level geographies,
    calculating:
    - proportion of highly deprived areas
    - extent (proportion of the local population that live in the most
      deprived areas)
    - population-weighted average score
}
