% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whichcol.R
\name{whichcol}
\alias{whichcol}
\title{Which column}
\usage{
whichcol(pattern, tibble, label = TRUE, ignore.case = TRUE, ...)
}
\arguments{
\item{pattern}{character string containing a \link[base]{regular expression}
    (or character string for \code{fixed = TRUE}) to be matched
    in the given character vector.  Coerced by
    \code{\link[base]{as.character}} to a character string if possible.  If a
    character vector of length 2 or more is supplied, the first element
    is used with a warning.  Missing values are allowed except for
    \code{regexpr}, \code{gregexpr} and \code{regexec}.}

\item{tibble}{a tibble object.}

\item{label}{a logical value indicating if pattern should be searched in
variable label, instead of variable name. Default is \code{TRUE}.}

\item{ignore.case}{if \code{FALSE}, the pattern matching is \emph{case
      sensitive} and if \code{TRUE}, case is ignored during matching.}

\item{...}{
  Arguments passed on to \code{\link[base:grep]{base::grepl}}
  \describe{
    \item{\code{perl}}{logical.  Should Perl-compatible regexps be used?}
    \item{\code{fixed}}{logical.  If \code{TRUE}, \code{pattern} is a string to be
    matched as is.  Overrides all conflicting arguments.}
    \item{\code{useBytes}}{logical.  If \code{TRUE} the matching is done
    byte-by-byte rather than character-by-character.  See
    \sQuote{Details}.}
  }}
}
\value{
A data frame.
}
\description{
Retrieves column names and labels that matches a general expression via
\link[base]{grepl}.
}
\examples{
# tibble generated by haven
input <- system.file("extdata/reds", package = "ILSAmerge")
x <- do.call(rbind,justload(inputdir = input,population = "BCGV1"))
x

whichcol("weight",x)

}
\keyword{tibblemanagement}
