% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lab.qcdata.R
\name{lab.qcdata}
\alias{lab.qcdata}
\title{Quality Control Data}
\usage{
lab.qcdata(data, var.index = 1, replicate.index = 2, material.index = 3,
  laboratory.index = 4, data.name = NULL)
}
\arguments{
\item{data}{Matrix or data-frame that contains the data, replicate index, type of material, and the laboratory.}

\item{var.index}{Scalar with the column number corresponding to the observed variable (the critical to quality variable). 
Alternatively, a string with the name of a quality variable can be provided.}

\item{replicate.index}{Scalar with the column number corresponding to the index each replicate.}

\item{material.index}{Scalar corresponding to the replicated number.}

\item{laboratory.index}{Scalar that defines the index number of each laboratory.}

\item{data.name}{String specifying the name of the variable which appears on the plots. 
If name is not provided, it is retrieved from the object.}
}
\description{
It creates a 'lab.qcdata' class object to perform the interlaboratory study. 
This object is used to plot ILS data and more.
}
\examples{
library(ILS)
data(Glucose)
Glucose.qcdata <- lab.qcdata(Glucose)
str(Glucose.qcdata)
summary(Glucose.qcdata)
}
