% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lab.fqcs.R
\name{h.fqcs}
\alias{h.fqcs}
\alias{h.fqcs.default}
\alias{h.fqcs.lab.fqcd}
\title{This function is used to compute the FDA Mandel's h statistic.}
\usage{
h.fqcs(x, ...)

\method{h.fqcs}{default}(x, argvals = NULL, rangeval = NULL, ...)

\method{h.fqcs}{lab.fqcd}(x, ...)
}
\arguments{
\item{x}{A (m x p) matrix or data-frame. Alternatively an (m x p x n) array. 
The m parameter is the number of curves, p defines the number of points observed in each curve, 
and n is the number of replicates.}

\item{...}{Arguments passed to or from methods.}

\item{argvals}{Argvals, by default: 1:p.}

\item{rangeval}{Range of discretization points, by default: range(argvals).}
}
\description{
It develops an object of 'h.fqcs' class to perform statistical quality control analysis. 
This function is used to compute the functional approach of  Mandel's h statistic. 
It is specifically designed to deal with experimental data results defined by curves such as thermograms and spectra.
}
\examples{
library(ILS)
data(TG)
delta <- seq(from = 40 ,to = 850 ,length.out = 1000 )
curves.fqcd <- lab.fqcd(TG, argvals = delta)
fh <- h.fqcs(curves.fqcd)
xlab <- "Temperature(Grade Celsius)"
ylab <- "Mass (\%)"
main <- "Functional hi  Estimation"
p <- fh$p
plot(fh,main = main, xlab = xlab, ylab = ylab,col=1:p,ylim=c(-3,3))
legend(10,3,paste("Lab",1:p),
      col=1:p,lty=1,lwd=2,cex=0.7)
}
\references{
\describe{
  \item{}{Febrero-Bande, M. and Oviedo, M. (2012),
   "Statistical computing in functional data analysis: the R package fda.usc". Journal of Statistical Software 51 (4), 1-28.}
  \item{}{Cuevas A., Febrero-Bande, M. and Fraiman, R. (2006), "On the use of the bootstrap for estimating functions with functional data". 
  Computational Statistics & Data Analysis 51, 2, 1063-1074. }
  \item{}{Naya, S., Tarrio-Saavedra. J., Lopez- Beceiro, J., Francisco Fernandez, M., Flores, M. and  Artiaga, R. (2014), 
  "Statistical functional approach for interlaboratory studies with thermal data". Journal of Thermal Analysis and Calorimetry, 118,1229-1243.}
}
}

