% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{PlotCatalogToPdf}
\alias{PlotCatalogToPdf}
\title{Plot catalog to a PDF file}
\usage{
PlotCatalogToPdf(
  catalog,
  file,
  plot.SBS12 = NULL,
  cex = NULL,
  grid = NULL,
  upper = NULL,
  xlabels = NULL,
  ylabels = NULL,
  ylim = NULL
)
}
\arguments{
\item{catalog}{A catalog as defined in \code{\link{ICAMS}} with attributes
added. See \code{\link{as.catalog}} for more details. \code{catalog} can
also be a numeric \code{matrix}, numeric \code{data.frame}, or a
\code{vector} denoting the mutation \strong{counts}, but \strong{must} be in the
correct row order used in \code{\link{ICAMS}}. See
\code{\link{CatalogRowOrder}} for more details. If \code{catalog} is a
\code{vector}, it will be converted to a 1-column \code{matrix} with
rownames taken from the element names of the \code{vector} and with column
name \code{"Unknown"}.}

\item{file}{The name of the PDF file to be produced.}

\item{plot.SBS12}{Only meaningful for class \code{SBS192Catalog}; if \code{TRUE},
generate an abbreviated plot of only SBS without context, i.e. 
C>A, C>G, C>T, T>A, T>C, T>G each on transcribed and untranscribed strands,
rather than SBS in trinucleotide context, e.g.
ACA > AAA, ACA > AGA, ..., TCT > TAT, ... There are 12 bars in the graph.}

\item{cex}{Has the usual meaning. A default value has been used by the
program internally. Only implemented for SBS96Catalog, SBS192Catalog and
DBS144Catalog.}

\item{grid}{A logical value indicating whether to draw grid lines. Only
implemented for SBS96Catalog, DBS78Catalog, IndelCatalog.}

\item{upper}{A logical value indicating whether to draw horizontal lines and
the names of major mutation class on top of graph. Only implemented for
SBS96Catalog, DBS78Catalog, IndelCatalog.}

\item{xlabels}{A logical value indicating whether to draw x axis labels. Only
implemented for SBS96Catalog, DBS78Catalog, IndelCatalog. If \code{FALSE} then plot x
axis tick marks for SBS96Catalog; set \code{par(tck = 0)} to suppress.}

\item{ylabels}{A logical value indicating whether to draw y axis labels. Only
implemented for SBS96Catalog, DBS78Catalog, IndelCatalog.}

\item{ylim}{Has the usual meaning. Only implemented for SBS96Catalog and
IndelCatalog.}
}
\value{
An \strong{invisible} list whose first element is a logic value
  indicating whether the plot is successful. For \strong{SBS192Catalog} with
  "counts" catalog.type and non-null abundance and \code{plot.SBS12 = TRUE},
  the list will have a second element which is a list containing the strand
  bias statistics.
}
\description{
Plot catalog to a PDF file. The type of graph is based on 
\code{attribute("catalog.type")} of the input catalog. You can first use
\code{\link{TransformCatalog}} to get different types of catalog and then do
the plotting.
}
\note{
The sizes of repeats involved in deletions range from 0 to 5+ in the
  mutational-spectra and signature catalog rownames, but for plotting and
  end-user documentation deletion repeat sizes range from 1 to 6+.
}
\section{Comments}{
 For \strong{SBS192Catalog} with "counts" catalog.type and
  non-NULL abundance and \code{plot.SBS12 = TRUE}, the strand bias statistics
  are Benjamini-Hochberg q-values based on two-sided binomial tests of the
  mutation counts on the transcribed and untranscribed strands relative to
  the actual abundances of C and T on the transcribed strand. On the SBS12
  plot, asterisks indicate q-values as follows *, \eqn{Q<0.05}; **,
  \eqn{Q<0.01}; ***, \eqn{Q<0.001}.
}

\examples{
file <- system.file("extdata",
                    "strelka.regress.cat.sbs.96.csv",
                    package = "ICAMS")
catSBS96 <- ReadCatalog(file)
colnames(catSBS96) <- "sample"
PlotCatalogToPdf(catSBS96, file = file.path(tempdir(), "test.pdf"))
}
