% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write_catalog.R
\name{ReadCatalog}
\alias{ReadCatalog}
\title{Read catalog.}
\usage{
ReadCatalog(file, ref.genome, region, catalog.type, strict = TRUE)
}
\arguments{
\item{file}{Path to a catalog on disk in the standardized format.}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{region}{region A character string designating a genomic region;
see \code{\link{as.catalog}} and \code{\link{ICAMS}}.}

\item{catalog.type}{One of "counts", "density", "counts.signature",
"density.signature".}

\item{strict}{If TRUE, do additional checks on the input, and stop if the
checks fail.}
}
\value{
A catalog as an S3 object; see \code{\link{as.catalog}}.
}
\description{
Read a catalog in standardized format from path.
}
\details{
See also \code{\link{WriteCatalog}}
}
\note{
In ID (insertion and deletion) catalogs, deletion repeat sizes
  range from 0 to 5+, but for plotting and end-user documentation
  deletion repeat sizes range from 1 to 6+.
}
\examples{
file <- system.file("extdata",
                    "strelka.regress.cat.sbs.96.csv",
                    package = "ICAMS")
catSBS96 <- ReadCatalog(file, ref.genome = "hg19", 
                        region = "genome",
                        catalog.type = "counts")
}
