% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooOth.R
\name{pMeltT}
\alias{pMeltT}
\title{Melting Pressure, Function of Temperature}
\usage{
pMeltT(T)
}
\arguments{
\item{T}{Temperature [K]}
}
\value{
The melting pressure: pMelt [ MPa ] for regions III, V , VI and VII

The melting pressure: pMeltIh [ MPa ] for region Ih

The sublimation pressure: pSubl [ MPa ], below triple point Temperature

Error message (if an error occur)
}
\description{
The function \code{pMeltT(T)} returns the water melting pressur,
     pMelt [ MPa ], for a given T [K]
}
\details{
This function calls a Fortran DLL that solves the equations given at the
     Revised Release on the Pressure along the Melting and Sublimation Curves of
     Ordinary Water Substance (September 2011), developed by the International 
     Association for the Properties of Water and Steam, 
     \url{http://www.iapws.org/relguide/MeltSub.html}. It is valid from the 
     Temperature of 256.164 [K] to the Temperature of 715 [K].
}
\examples{
T <- 275.
pMeltT(T)

}

