% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.HydePosterior.R
\name{print.HydeSim}
\alias{print.HydeSim}
\title{Print a Hyde Simulated Distribution Object}
\usage{
\method{print}{HydeSim}(x, ...)
}
\arguments{
\item{x}{a \code{HydeSim} object}

\item{...}{additional arguments to be passed to print methods.  Currently 
none in use.}
}
\description{
Prints a brief description of a HydeSim object.
}
\details{
Prints the number of posterior distributions, chains, and 
  iterations, as well as the observed values.
}
\examples{
data(PE, package="HydeNet")
Net <- HydeNetwork(~ wells + 
                     pe | wells + 
                     d.dimer | pregnant*pe + 
                     angio | pe + 
                     treat | d.dimer*angio + 
                     death | pe*treat,
                     data = PE) 

Net <- setDecisionNodes(Net, treat)  
                 
compiledNet <- compileJagsModel(Net, n.chains=5)

#* Generate the posterior distribution for the model (but not the 
#* decision model)
Posterior <- HydeSim(compiledNet, 
                           variable.names = c("d.dimer", "death"), 
                           n.iter = 1000)
Posterior

#* Generate the posterior for the decision model
Decision <- compileDecisionModel(Net, n.chains=5)
Posterior_decision <- HydeSim(Decision, 
                                    variable.names = c("d.dimer", "death"), 
                                    n.iter = 1000)

}
\author{
Jarrod Dalton and Benjamin Nutter
}
