% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POR_apply_annual_hiflow_stats.R
\name{POR_apply_annual_hiflow_stats}
\alias{POR_apply_annual_hiflow_stats}
\title{Calculate the 50th and 90th percentiles of a streamflow time series}
\usage{
POR_apply_annual_hiflow_stats(annual_max, quantile_type = 8)
}
\arguments{
\item{annual_max}{'numeric' vector or data.frame. Vector or data.frame with columns of annual
n-day maximum streamflows.}

\item{quantile_type}{'numeric' value. The distribution type used in the \code{\link[stats:quantile]{stats::quantile}}
function. Default is \code{8} (median-unbiased regardless of distribution). Other
types common in hydrology are \code{6} (Weibull) or \code{9} (unbiased for normal distributions).}
}
\value{
Data.frame of 0.5 and 0.9 non-exceedance probabilities (50th and 90th percentiles),
with metric names if \code{annual_max} is a data.frame with columns named by metric.
}
\description{
This function computes the 50th and 90th percentiles of a streamflow time series from annual
n-day high flow values and returns a data.frame in the format of other period-of-record (POR)
metrics.
}
\details{
annual maximum of n-day moving averages can be computed during pre-processing step using \cr
\code{\link{preproc_precondition_data}} and \code{\link{calc_annual_flow_stats}}, or \code{\link{preproc_main}} for both
observed and modeled data.
}
\examples{
POR_apply_annual_hiflow_stats(annual_max = example_annual[ , c("high_q1", "high_q30")])

}
\seealso{
\code{\link[stats]{quantile}}, \code{\link{preproc_precondition_data}},
\code{\link{calc_annual_flow_stats}}, \code{\link{preproc_main}}
}
\keyword{annual-statistics}
\keyword{period-of-record}
