% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EvaluateCandidateListAgainstRawData.R
\name{EvaluateCandidateListAgainstRawData}
\alias{EvaluateCandidateListAgainstRawData}
\title{EvaluateCandidateListAgainstRawData.}
\usage{
EvaluateCandidateListAgainstRawData(
  x = NULL,
  tp = NULL,
  gr = NULL,
  dat = NULL,
  dmz = 0.025,
  drt = 1,
  dEcut = 1,
  Pcut = 0.01,
  Icut = 1000,
  method = c("APCI", "ESI")[1],
  rolp = c("non", "pos", "neg", "all")[2],
  smooth = 0
)
}
\arguments{
\item{x}{Dataframe of results (output of EvaluatePairsFromXCMSet).}

\item{tp}{Timepoint.}

\item{gr}{group, e.g. different genotypes or concentrations.}

\item{dat}{list of xcmsRaw's for deconvolution and plotting.}

\item{dmz}{Allowed mass deviation in Da (for BPC extraction).}

\item{drt}{Allowed rt deviation in seconds (for get extraction).}

\item{dEcut}{Minimum required change in enrichment before a candidate ID is assigned.}

\item{Pcut}{Maximum allowed P value before a candidate ID is assigned.}

\item{Icut}{Minimum required median peak intensity before a candidate ID is assigned.}

\item{method}{Either APCI or ESI. Choice will modify some internal parameters and checks performed.}

\item{rolp}{RemoveOverLappingPeaks paramter.}

\item{smooth}{Smoothing parameter passed to \link{getMultipleBPC}.}
}
\value{
A list of evaluation results.
}
\description{
\code{EvaluateCandidateListAgainstRawData} will analyze an xcmsSet result for mass pairs (mz1, mz2) with changes due to 13C incorporation.
}
\details{
This function will evaluate candidate mz pairs found within an xcmsSet object by \link{EvaluatePairsFromXCMSSet} against the raw measurement data.
A special parameter is 'rolp' which can be set to 'non', 'pos', 'neg' or 'all'. It will influence the time performance of the function be determining how many peaks are effectively tested.
If 'rolp' is set to 'non', no overlapping peaks will be skipped, every individual mz-pair will be sequentially evaluated (slow but most informative).
If it is set to 'pos' or 'neg', overlapping peaks (determined by experiment wide deconvolution) will not be tested aditionally for positive or negative hits ('neg' is standard).
If set to 'all' overlapping peaks will always be removed from the list of mz-pairs to be tested (fast).
}
\examples{
# Please use examples from previous versions as xcms (and xcms objects)
# are no longer supported during CRAN checks leading to package rejection
# if included (and I do not know a work around). :(

}
