% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.LD50.R
\name{logLik.LD50}
\alias{logLik.LD50}
\title{Return Log Likelihood of a fit generated by LD50}
\usage{
\method{logLik}{LD50}(object, ...)
}
\arguments{
\item{object}{A result file generated by fitRMU}

\item{...}{Not used}
}
\value{
The Log Likelihood value for the fitted model with data
}
\description{
Return Log Likelihood of a fit generated by LD50
}
\details{
logLik.LD50 Return Log Likelihood of a fit for LD50
}
\examples{
\dontrun{
data <- data.frame(Doses=c(80, 120, 150, 150, 180, 200),
Alive=c(10, 12, 8, 6, 2, 1),
Dead=c(0, 1, 5, 6, 9, 15))
LD50_logistic <- LD50(data, equation="logistic")
logLik(LD50_logistic)
AIC(LD50_logistic)
}
}
\seealso{
Other LD50 functions: 
\code{\link{LD50}()},
\code{\link{LD50_MHmcmc}()},
\code{\link{LD50_MHmcmc_p}()},
\code{\link{plot.LD50}()},
\code{\link{predict.LD50}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{LD50 functions}
