% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functioncollection_import.R
\name{ReadObs}
\alias{ReadObs}
\alias{ReadPTQobs}
\title{Read HYPE observation data files}
\usage{
ReadObs(
  filename,
  variable = "",
  dt.format = NULL,
  nrows = -1,
  type = c("df", "dt"),
  select = NULL,
  obsid = NULL
)

ReadPTQobs(
  filename,
  variable = "",
  dt.format = NULL,
  nrows = -1,
  type = c("df", "dt"),
  select = NULL,
  obsid = NULL
)
}
\arguments{
\item{filename}{Path to and file name of the file to import. Windows users: Note that
Paths are separated by '/', not '\\'.}

\item{variable}{Character string, HYPE variable ID of file contents. If \code{""} (default), the ID is extracted
from \code{filename}, which only works with HYPE input data file names or file names including those names
(e.g. 'Pobs_old.txt', 'testSFobs.txt'). Some of the observation data files have no corresponding HYPE variable ID.
In these cases, a dummy ID is used, see table in Details. If automatic extraction fails, attribute \code{variable} is set
to \code{"other"}. Alternatively, any other variable name can be provided.}

\item{dt.format}{Optional date-time \code{format} string as in \code{\link{strptime}}. If \code{NULL}, then HYPEtools will try to identify
the format automatically.}

\item{nrows}{Number of rows to import. A value of \code{-1} indicates all rows, a positive integer gives the number of rows
to import.}

\item{type}{Character, keyword for data type to return. \code{"df"} to return a standard data frame or \code{"dt"} to
return a \code{\link[data.table]{data.table}} object.}

\item{select}{Integer vector, column numbers to import. Note: first column with dates must be imported and will be added if missing.}

\item{obsid}{Integer vector, HYPE OBSIDs to import. Alternative to argument \code{select}, takes precedence if both are provided.}
}
\value{
\code{ReadObs} returns a data frame or data table with additional attributes: \code{obsid} with observation IDs, \code{timestep}
with a time step string, either \code{"day"} or \code{"nhour"} (only daily or n-hourly time steps supported), and \code{variable}
with a HYPE variable ID string.
}
\description{
Import single-variable HYPE observation files into R.
}
\details{
\code{ReadObs} is a convenience wrapper function of \code{\link[data.table]{fread}} from package
\link[data.table:data.table]{data.table::data.table},
with conversion of date-time strings to POSIX time representations. Observation IDs (SUBIDs or IDs connected to SUBIDs with a
\href{http://hype.smhi.net//wiki/doku.php?id=start:hype_file_reference:forckey.txt}{ForcKey.txt file}) are returned as integer
attribute \code{obsid} (directly accessible through \code{\link{obsid}}).

Observation file types with automatic (dummy) \code{variable} attribute assignment:\tabular{lc}{
   \strong{File} \tab \strong{HYPE variable ID} \cr
    \tab (*: dummy ID) \cr
   Pobs.txt \tab prec \cr
   Tobs.txt \tab temp \cr
   Qobs.txt \tab rout \cr
   TMINobs.txt \tab tmin* \cr
   TMAXobs.txt \tab tmax* \cr
   VWobs.txt \tab vwnd* \cr
   UWobs.txt \tab uwnd* \cr
   SFobs.txt \tab snff* \cr
   SWobs.txt \tab swrd* \cr
   RHobs.txt \tab rhum* \cr
   Uobs.txt \tab wind* \cr
}
}
\note{
For the conversion of date/time strings, time zone "UTC" is assumed. This is done to avoid potential daylight saving time
side effects when working with the imported data (and e.g. converting to string representations during the process).
}
\examples{
te <- ReadObs(filename = system.file("demo_model", "Tobs.txt", package = "HYPEtools"))
head(te)

}
\seealso{
\code{\link{WriteObs}}
\code{\link{ReadXobs}} for multi-variable HYPE observation files
}
