% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_PlotMapOutput.R
\name{PlotMapOutput}
\alias{PlotMapOutput}
\title{Plot function for HYPE map results.}
\usage{
PlotMapOutput(
  x,
  map,
  map.subid.column = 1,
  var.name = "",
  map.type = "default",
  plot.legend = TRUE,
  legend.pos = "bottomright",
  legend.title = NULL,
  legend.signif = 2,
  col = "auto",
  col.ramp.fun,
  col.breaks = NULL,
  col.rev = FALSE,
  plot.scale = TRUE,
  scale.pos = "br",
  plot.arrow = TRUE,
  arrow.pos = "tr",
  weight = 0.15,
  opacity = 0.75,
  fillOpacity = 0.5,
  na.color = "#808080",
  plot.searchbar = FALSE,
  plot.label = FALSE,
  plot.label.size = 2.5,
  plot.label.geometry = c("centroid", "surface"),
  file = "",
  width = NA,
  height = NA,
  units = c("in", "cm", "mm", "px"),
  dpi = 300,
  vwidth = 1424,
  vheight = 1000,
  html.name = "",
  map.adj = 0,
  legend.outer = FALSE,
  legend.inset = c(0, 0),
  par.cex = 1,
  par.mar = rep(0, 4) + 0.1,
  add = FALSE
)
}
\arguments{
\item{x}{HYPE model results, typically 'map output' results. Data frame object with two columns, first column containing SUBIDs and
second column containing model results to plot. See details.}

\item{map}{A \code{SpatialPolygonsDataFrame} or \code{sf} object. Typically an imported sub-basin vector polygon file. Import of vector polygons
requires additional packages, e.g. \link[sf:st_read]{sf::st_read}. For interactive Leaflet maps a small/simplified polygon file should be used as larger
files can take an excessive amount of time to render.}

\item{map.subid.column}{Integer, column index in the \code{map} 'data' \code{\link{slot}} holding SUBIDs (sub-catchment IDs).}

\item{var.name}{Character string. HYPE variable name to be plotted. Mandatory for automatic color ramp selection of pre-defined
HYPE variables (\code{col = "auto"}). Not case-sensitive. See details.}

\item{map.type}{Map type keyword string. Choose either \code{"default"} for the default static plots or \code{"leaflet"} for interactive Leaflet maps. Use \code{"legacy"} for deprecated static plots.}

\item{plot.legend}{Logical, plot a legend along with the map.}

\item{legend.pos}{Keyword string for legend position. For static plots, one of: \code{"none"}, \code{"left"}, \code{"right"},
\code{"bottom"}, \code{"top"}, or a two-element numeric vector. For interactive Leaflet maps, one of: \code{"topleft"}, \code{"topright"}, \code{"bottomright"}, \code{"bottomleft"}. For legacy static plots, one of: \code{"left"}, \code{"topleft"}, \code{"topright"},
\code{"right"}, \code{"bottomright"}, \code{"bottomleft"}.}

\item{legend.title}{Character string or mathematical expression. An optional title for the legend. If none is provided here, \code{var.name}
is used as legend title string. For select HYPE variables, pretty legend titles are in-built.}

\item{legend.signif}{Integer, number of significant digits to display in legend labels.}

\item{col}{Colors to use on the map. One of the following: \itemize{
\item \code{"auto"} to allow for automatic selection from tailored color ramp palettes and break points based on argument \code{var.name},
see details
\item A color ramp palette function, e.g. as returned from a call to \code{\link{colorRampPalette}}. A number of tailored functions are
available in \code{HYPEtools}, see \code{\link{CustomColors}}
\item A vector of colors. This can be a character vector of R's built-in color names or hexadecimal strings as returned by
\code{\link{rgb}}, or an integer vector of current \code{\link{palette}} indices.
}}

\item{col.ramp.fun}{DEPRECATED, for backwards compatibility only.}

\item{col.breaks}{A numeric vector, specifying break points for discretization of model result values into classes. Used if a color palette is specified with \code{col} argument.
Class boundaries will be interpreted as right-closed, i.e upper boundaries included in class. Lowest class boundary included in lowest class as well.
Meaningful results require the lowest and uppermost breaks to bracket all model result values, otherwise there will be
unclassified white spots on the map plot. Not mandatory, can optionally
be combined with one of the pre-defined palettes, including \code{"auto"} selection. Per default, a generic
classification will be applied (see details).}

\item{col.rev}{Logical, If \code{TRUE}, then color palette will be reversed.}

\item{plot.scale}{Logical, plot a scale bar on map. NOTE: Scale bar may be inaccurate for geographic coordinate systems (Consider switching to projected coordinate system).}

\item{scale.pos}{Keyword string for scalebar position for static maps. One of \code{bl}, \code{br}, \code{tr}, or \code{tl}. See \code{\link{annotation_scale}}.}

\item{plot.arrow}{Logical, plot a North arrow in static maps.}

\item{arrow.pos}{Keyword string for north arrow position for static maps. One of \code{bl}, \code{br}, \code{tr}, or \code{tl}. See \code{\link{annotation_north_arrow}}.}

\item{weight}{Numeric, weight of subbasin boundary lines. See \code{\link{geom_sf}} for static maps and \code{\link[leaflet:map-layers]{leaflet::addPolygons()}} for Leaflet maps.}

\item{opacity}{Numeric, opacity of subbasin boundary lines in Leaflet maps. See \code{\link[leaflet:map-layers]{leaflet::addPolygons()}}.}

\item{fillOpacity}{Numeric, opacity of subbasin polygons in Leaflet maps. See \code{\link[leaflet:map-layers]{leaflet::addPolygons()}}.}

\item{na.color}{Character string of color to use to symbolize subbasin polygons in maps which correspond to \code{NA} values.}

\item{plot.searchbar}{Logical, if \code{TRUE}, then a search bar will be included within Leaflet maps. See \code{\link[leaflet.extras:search-features]{leaflet.extras::addSearchFeatures()}}.}

\item{plot.label}{Logical, if \code{TRUE}, then labels will be displayed on default static maps and in Leaflet maps when the cursor hovers over subbasins.
See \code{\link{geom_sf_text}} for default maps and \code{\link[leaflet:map-layers]{leaflet::addPolygons()}} for Leaflet maps.}

\item{plot.label.size}{Numeric, size of text for labels on default static plots. See \code{\link{geom_sf_text}}.}

\item{plot.label.geometry}{Keyword string to select where plot labels should be displayed on the default static plots. Either \code{centroid} to use \code{sf::st_centroid} or \code{surface} to use \code{sf::st_point_on_surface}.}

\item{file}{Save map to an image file by specifying the path to the desired output file using this argument. File extension must be specified. See \code{\link{ggsave}} for static maps and
\code{\link[mapview:mapshot]{mapview::mapshot()}} for Leaflet maps. You may need to run \code{webshot::install_phantomjs()} the first time you save a Leaflet map to an image file. See \code{\link[webshot:install_phantomjs]{webshot::install_phantomjs()}}.}

\item{width}{Numeric, width of output plot for static maps in units of \code{units}. See \code{\link{ggsave}}.}

\item{height}{Numeric, height of output plot for static maps in units of \code{units}. See \code{\link{ggsave}}.}

\item{units}{Keyword string for units to save static map. One of \code{"in"}, \code{"cm"}, \code{"mm"}, \code{"px"}. See \code{\link{ggsave}}.}

\item{dpi}{Integer, resolution to save static map. See \code{\link{ggsave}}.}

\item{vwidth}{Numeric, width of the exported Leaflet map image in pixels. See \code{\link[mapview:mapshot]{mapview::mapshot()}}.}

\item{vheight}{Numeric, height of the exported Leaflet map image in pixels. See \code{\link[mapview:mapshot]{mapview::mapshot()}}.}

\item{html.name}{Save Leaflet map to an interactive HTML file by specifying the path to the desired output file using this argument.
File extension must be specified. See \code{\link[htmlwidgets:saveWidget]{htmlwidgets::saveWidget()}}.}

\item{map.adj}{Numeric, map adjustment in direction where it is smaller than the plot window. A value of \code{0} means left-justified
or bottom-justified, \code{0.5} (the default) means centered, and \code{1} means right-justified or top-justified. Only used for default maps.}

\item{legend.outer}{Logical. If \code{TRUE}, outer break point values will be plotted in legend.}

\item{legend.inset}{Numeric, inset distance(s) from the margins as a fraction of the plot region for legend, scale and north arrow.
See \code{\link{legend}} and details below.}

\item{par.cex}{Numeric, character expansion factor. See description of \code{cex} in \code{\link{par}}. Only used for default maps.}

\item{par.mar}{Plot margins as in \code{\link{par}} argument \code{mar}. Defaults to a nearly margin-less plot.
In standard use cases of this function, plot margins do not need to be changed. Only used for default maps.}

\item{add}{Logical, default \code{FALSE}. If \code{TRUE}, add to existing plot. In that case \code{map.adj} has no effect. Only used for default maps.}
}
\value{
For default static maps, \code{PlotMapOutput} returns an object of class \code{ggplot}. This plot can also be assigned to a variable in the environment.
For interactive Leaflet maps, \code{PlotMapOutput} returns an object of class \code{leaflet}. For legacy static plots, \code{PlotMapOutput} returns a plot to the
currently active plot device, and invisibly an object of class \code{SpatialPolygonsDataFrame} as provided in argument \code{map}, with plotted values and color codes added as columns
in the data slot.
}
\description{
Draw HYPE map results, with pretty scale discretizations and color ramp defaults for select HYPE variables.
}
\details{
\code{PlotMapOutput} plots HYPE results from 'map[variable name].txt' files, typically imported using \code{\link{ReadMapOutput}}.
\code{x} arguments \strong{must} contain the variable of interest in the second column. For map results with multiple columns, i.e.
several time periods, pass index selections to \code{x}, e.g. \code{mymapresult[, c(1, 3)]}.

\code{PlotMapOutput} can return static plots or interactive Leaflet maps depending on value provided for the argument \code{map.type}.
For backwards compatibility, legacy static plots can still be generated by setting \code{map.type} to \code{legacy}. For legacy plots, \code{legend.pos} and
\code{map.adj} should be chosen so that legend and map do not overlap, and the legend position can be fine-tuned using
argument \code{legend.inset}. This is particularly useful for legend titles with more than one line. In order to move map and legend closer to each other, change the plot device width.
For details on inset specification for the default maps, see \code{inset} in \code{\link{legend}}.

Mapped variables are visualized using color-coded data intervals. \code{HYPEtools} provides a number of color ramps functions for HYPE variables,
see \code{\link{CustomColors}}. These are either single-color ramps with less saturated colors for smaller values
and more saturated values for higher values, suitable for e.g. concentration or volume ranges, or multi-color ramps suitable for calculated
differences, e.g. between two model runs.

Break points between color classes of in-built or user-provided color ramp palettes can optionally be provided in argument
\code{col.breaks}. This is particularly useful when specific pretty class boundaries are needed, e.g. for publication figures. Per default,
break points for internal single color ramps and user-provided ramps are calculated based on 10\\% percentiles of HYPE results given in
\code{x}. Default break points for internal color ramp \code{ColDiffGeneric} are based on an equal distance classification of log-scaled
\code{x} ranges, centered around zero. For internal color ramp \code{ColDiffTemp}, they are breaks in an interval from -7.5 to 7.5 K.

For select common HYPE variables, given in argument \code{var.name}, an automatic color ramp selection including pretty breaks and legend titles
is built into \code{PlotMapOutput}. These are 'CCTN', 'CCTP', 'COUT', and 'TEMP'. Automatic selection is activated by choosing keyword
\code{"auto"} in \code{col}. All other HYPE variables will be plotted using a generic color ramp palette and generic break points with
\code{"auto"} color selection.
}
\examples{
\donttest{
# Import plot data and subbasin polygons
require(sf)
te1 <- ReadMapOutput(filename = system.file("demo_model",
"results", "mapCRUN.txt", package = "HYPEtools"), dt.format = NULL)
te2 <- st_read(dsn = system.file("demo_model",
"gis", "Nytorp_map.gpkg", package = "HYPEtools"))
# plot runoff map
PlotMapOutput(x = te1, map = te2, map.subid.column = 25,
var.name = "CRUN", col = ColQ)
}


}
\seealso{
\code{\link{ReadMapOutput}} for HYPE result import; \code{\link{PlotMapPoints}} for plotting HYPE results at points, e.g. sub-basin outlets.
}
