% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHVT.R
\name{plotHVT}
\alias{plotHVT}
\title{Plot the hierarchical tesselations.

Main plotting function to construct hierarchical voronoi tessellations.}
\arguments{
\item{hvt.results}{List. A list containing the ouput of \code{HVT} function
which has the details of the tessellations to be plotted.}

\item{line.width}{Numeric Vector. A vector indicating the line widths of the
tessellation boundaries for each level.}

\item{color.vec}{Vector. A vector indicating the colors of the boundaries of
the tessellations at each level.}

\item{pch1}{Numeric. Symbol type of the centroids of the tessellations
(parent levels). Refer \code{\link{points}}. (default = 21)}

\item{centroid.size}{Numeric. Size of centroids of first level
tessellations. (default = 3)}

\item{title}{String. Set a title for the plot. (default = NULL)}

\item{maxDepth}{Numeric. An integer indicating the number of levels. (default = NULL)}
}
\value{
ggplot object containing the main HVT plot for the given HVT results
}
\description{
Plot the hierarchical tesselations.

Main plotting function to construct hierarchical voronoi tessellations.
}
\examples{

data("USArrests", package = "datasets")

hvt.results <- list()
hvt.results <- HVT(USArrests,
  n_cells = 15, depth = 1, quant.err = 0.2,
  distance_metric = "L1_Norm", error_metric = "mean",
  projection.scale = 10, normalize = TRUE,
  quant_method = "kmeans", diagnose = TRUE
)
plotHVT(hvt.results,
  line.width = c(0.8), color.vec = c("#141B41"),
  maxDepth = 1
)

}
\seealso{
\code{\link{HVT}} \cr \code{\link{hvtHmap}}
}
\author{
Shubhra Prakash <shubhra.prakash@mu-sigma.com>, Sangeet Moy Das <sangeet.das@mu-sigma.com>
}
\keyword{hplot}
