% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurdat.R
\docType{package}
\name{HURDAT}
\alias{HURDAT}
\alias{HURDAT-package}
\title{HURDAT}
\description{
This R package currently aims to reorganize the NOAA HURDAT2
dataset for Atlantic, East Pacific and Central Pacific-basin tropical
cyclones and present it in a cleaner format.
}
\details{
The Atlantic basin dataset covers all cyclones that have developed in the
Atlantic Ocean. The eastern Pacific datasets cover cyclones in the Pacific
from the United States/Mexico coastlines to -140&deg;W where the cyclone
entered what is referred to as the central Pacific basin. The central
Pacific basin extends westward to -180&deg;W.
}
\section{Named Cyclones}{


Cyclones were not named until 1950 and used names of the international
phonetic alphabet. For example, Able, Baker, Charlie, etc.

In 1953, the \href{http://www.nhc.noaa.gov}{National Hurricane Center} began
using female names and by 1954 the NHC would retire some names for storms of
significance. Currently the
\href{http://www.wmo.int/pages/prog/www/tcp/Storm-naming.html}{World
  Meteorological Organization}
is responsible for maintaining the list of names, retiring names and
assigning replacement names.

In this dataset, cyclones not named are simply referred to as "UNNAMED". To
aid with identification, cyclones will be referenced by their `Key`, a
string of alphanumeric characters identifying basin, the number of the storm
for the year, followed by the four-digit year.

For example, *AL011851*:
\itemize{
  \item AL = Atlantic Basin (`Basin`)
  \item 01 = First storm of the year (`YearNum`)
  \item 1851 = Year of the storm (`Year`)
}
}

\section{Meteorological Definitions}{


It is useful to understand definitions and classifications of tropical
cyclones.
\itemize{
  \item Cyclone: a system of winds rotating inward to an area of low
    pressure. This system rotates counter-clockwise in the northern
    hemisphere and clockwise in the southern hemisphere.
  \item Tropical depression: a tropical cyclone with winds less than 35 mph
    (34 kts).
  \item Tropical storm: a tropical  with winds between 35 mph (34 kts) but
    less than 74mph (64 kts).
  \item Hurricane: a tropical cyclone with winds greater than 74 mph
    (64 kts).
  \item Extratropical Cyclone: a cyclone no longer containing tropical
    characteristics (warm-core center, tight pressure gradient near the
   center)
  \item Subtropical Cyclone: a cyclone containing a mix of tropical and
    non-tropical characteristics.
  \item Tropical cyclone: a warm-core surface low pressure system
  \item Tropical Wave: An open area of low pressure (trough) containing
    tropical characteristics
  \item Disturbance: An area of disturbed weather; a large disorganized area
    of thunderstorms.
}
}

\section{Error Reporting}{


Please submit any errors, discrepancies or issues through the
\href{https://github.com/timtrice/HURDAT/issues}{timtrice/HURDAT} repository.

Errors in the raw data may also be reported to Chris Landsea or the National
Hurricane Center Best Track Change Committee
\href{http://www.aoml.noaa.gov/hrd/hurdat/submit_re-analysis.html}{as
  explained on the HRD website}.
}

