% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.r
\name{split_data}
\alias{split_data}
\title{Split data into train and test partitions}
\usage{
split_data(X, y, p.train = 0.7, n.train = round(nrow(X) * p.train))
}
\arguments{
\item{X}{Input matrix, of dimension nobs by nvars; each row is an observation vector.}

\item{y}{Vector of response variables.}

\item{p.train}{Percentage of training set.}

\item{n.train}{Number of cases for training; will override \code{p.train} if specified.}
}
\value{
List of training data \code{x.tr}, \code{y.tr} and testing data \code{x.te}, \code{y.te}.
}
\description{
This function splits the input data and response variables into training and testing parts.
}
\examples{
dat <- gendata_MLR(n = 100, p = 10)
dat <- split_data(dat$X, dat$y, p.train = 0.7)
dim(dat$x.tr)
dim(dat$x.te)
   
}
