% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survHIMA.R
\name{survHIMA}
\alias{survHIMA}
\title{High-dimensional mediation analysis for survival data}
\usage{
survHIMA(X, Z, M, OT, status, FDRcut = 0.05, scale = TRUE, verbose = FALSE)
}
\arguments{
\item{X}{a vector of exposure.}

\item{Z}{a matrix of adjusting covariates. Rows represent samples, columns represent variables. Can be \code{NULL}.}

\item{M}{a \code{data.frame} or \code{matrix} of high-dimensional mediators. Rows represent samples, columns 
represent mediator variables.}

\item{OT}{a vector of observed failure times.}

\item{status}{a vector of censoring indicator (\code{status = 1}: uncensored; \code{status = 0}: censored)}

\item{FDRcut}{FDR cutoff applied to define and select significant mediators. Default = \code{0.05}.}

\item{scale}{logical. Should the function scale the data? Default = \code{TRUE}.}

\item{verbose}{logical. Should the function be verbose? Default = \code{FALSE}.}
}
\value{
A data.frame containing mediation testing results of selected mediators (FDR <\code{FDPcut}). 
\itemize{
    \item{ID: }{index of selected significant mediator.}
    \item{alpha: }{coefficient estimates of exposure (X) --> mediators (M).}
    \item{alpha_se: }{standard error for alpha.}
    \item{beta: }{coefficient estimates of mediators (M) --> outcome (Y) (adjusted for exposure).}
    \item{beta_se: }{standard error for beta.}
    \item{p.joint: }{joint raw p-value of selected significant mediator (based on FDR).}
}
}
\description{
\code{survHIMA} is used to estimate and test high-dimensional mediation effects for survival data.
}
\examples{
\dontrun{
# Note: In the following example, M1, M2, and M3 are true mediators.
data(himaDat)

head(himaDat$Example3$PhenoData)

survHIMA.fit <- survHIMA(X = himaDat$Example3$PhenoData$Treatment,
                Z = himaDat$Example3$PhenoData[, c("Sex", "Age")], 
                M = himaDat$Example3$Mediator, 
                OT = himaDat$Example3$PhenoData$Time, 
                status = himaDat$Example3$PhenoData$Status, 
                FDRcut = 0.05,
                scale = FALSE, 
                verbose = TRUE)
survHIMA.fit
}

}
\references{
Zhang H, Zheng Y, Hou L, Zheng C, Liu L. Mediation Analysis for Survival Data with High-Dimensional Mediators. 
Bioinformatics. 2021. DOI: 10.1093/bioinformatics/btab564. PMID: 34343267. PMCID: PMC8570823
}
