% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDSpatialScan_summary.R
\name{summary.ResScanOutputUni}
\alias{summary.ResScanOutputUni}
\title{Summary of the clusters obtained with a univariate scan function (UG or UNP).}
\usage{
\method{summary}{ResScanOutputUni}(
  object,
  type_summ = "param",
  digits = 3,
  quantile.type = 7,
  only.MLC = FALSE,
  ...
)
}
\arguments{
\item{object}{ResScanOutputUni. Output of a univariate scan function (UG or UNP).}

\item{type_summ}{character. "param" or "nparam". "param" gives the mean and the sd for each variable in the clusters, outside, and globally and "nparam" gives the Q25, Q50 and Q75 quantiles for each variables in the clusters, outside, and globally.}

\item{digits}{integer. Number of decimals in the output.}

\item{quantile.type}{An integer between 1 and 9 (see function quantile). Ignored if type_summ is "param"}

\item{only.MLC}{logical. Should we summarize only the MLC or all the significant clusters?}

\item{...}{Further arguments to be passed to or from methods.}
}
\value{
No value returned, displays the results in the console
}
\description{
This function gives a summary of the clusters in a table
}
\examples{
\donttest{
library(sp)
data("map_sites")
data("multi_data")
uni_data <- multi_data[,1]
coords <- coordinates(map_sites)
res_unp <- SpatialScan(method = "UNP", data=uni_data, sites_coord = coords,
system = "WGS84", mini = 1, maxi = nrow(coords)/2)$UNP

summary(object = res_unp, type_summ = "nparam")}
\dontshow{
library(sp)
data("map_sites")
data("multi_data")
uni_data <- multi_data[,1]
coords <- coordinates(map_sites)
res_unp <- SpatialScan(method = "UNP", data=uni_data, sites_coord = coords,
system = "WGS84", mini = 1, maxi = nrow(coords)/2, MC = 9)$UNP
if(length(res_unp$sites_clusters)>0){
summary(object = res_unp, type_summ = "nparam")}
}

}
