/*
 * Decompiled with CFR 0.152.
 */
package ExperimentalDesign;

import ExperimentalDesign.AllExperimentalDesigns;

public abstract class MultipleSearchExperimentalDesigns
extends AllExperimentalDesigns {
    protected int max_designs;
    protected int[][] ending_indicTs;
    protected Double[] objective_vals;
    protected Integer[] num_iters;

    @Override
    public void beginSearch() {
        super.beginSearch();
        this.num_iters = new Integer[this.max_designs];
        this.ending_indicTs = new int[this.max_designs][this.n];
        this.objective_vals = new Double[this.max_designs];
    }

    public void setMaxDesigns(int n) {
        this.max_designs = n;
        System.out.println("max_designs " + this.max_designs);
    }

    public int progress() {
        int n = 0;
        if (this.objective_vals != null) {
            for (int i = 0; i < this.max_designs && this.objective_vals[i] != null; ++i) {
                ++n;
            }
        }
        return n;
    }

    public int[] getNumIters() {
        int n = this.progress();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.num_iters[i];
        }
        return nArray;
    }

    public double[] getObjectiveVals() {
        int n = this.progress();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.objective_vals[i] == null ? 0.0 : this.objective_vals[i];
        }
        return dArray;
    }

    public int[][] getEndingIndicTs(int[] nArray) {
        int[][] nArray2 = new int[nArray.length][this.n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.ending_indicTs[nArray[i]];
        }
        return nArray2;
    }

    public int[][] getEndingIndicTs() {
        return this.ending_indicTs;
    }
}

