# This function constructs graph Laplacian matrices from adjacency matrices
# Author: Sen Zhao
# Email: sen-zhao@sen-zhao.com

make.L <- function(adj, normalize.Laplacian = FALSE){
  if(isSymmetric(adj) == FALSE){
    stop("Error: The adjacency matrix needs to be symmetric.")
  }
  if(max(abs(adj)) > 1){
    stop("Error: Entries in the adjacency matrix need to be between -1 and 1.")
  }
  if(sum(abs(adj)) == 0){
    stop("Error: Adjacency matrix is empty.")
  }
  L <- -adj
  diag(L) <- 0
  diag(L) <- -rowSums(L)
  if(normalize.Laplacian){
    diag(L)[diag(L) == 0] <- 1
    L <- diag(1 / sqrt(diag(L))) %*% L %*% diag(1 / sqrt(diag(L)))
  }
  return(L)
}
