% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPval.R
\name{getPvalWilcox}
\alias{getPvalAnova}
\alias{getPvalChiSq}
\alias{getPvalFisher}
\alias{getPvalKruskal}
\alias{getPvalWilcox}
\title{P-value extractors for \code{\link{getDescriptionStatsBy}}}
\usage{
getPvalWilcox(x, by)

getPvalAnova(x, by)

getPvalFisher(x, by)

getPvalChiSq(x, by)

getPvalKruskal(x, by)
}
\arguments{
\item{x}{The main variable of interest}

\item{by}{The variable for the stratification}
}
\value{
\code{numeric} Returns the p-value from that particular test
}
\description{
These functions are the base functions for getting the description
p-values. You can provide your own functions but all functions should
take two arguments and return a p-value (numeric, non-formatted)
}
\section{getPvalWilcox}{


Performs a two-sample two-sided Wilcoxon tests (also known as the Mann-Whitney test),
see \code{\link[stats]{wilcox.test}}.
}

\section{getPvalAnova}{


Performs a standard Analysis of Variance model
through \code{\link[stats]{anova}(\link[stats]{lm}(x ~ by))}
}

\section{getPvalFisher}{

Performs Fisher's exact test through the \code{\link[stats]{fisher.test}}.
}

\section{getPvalChiSq}{


Performs a standard Chi-Squares analysis
through \code{\link[stats]{chisq.test}}
}

\section{getPvalKruskal}{


Performs a  Kruskal-Wallis rank sum test
through \code{\link[stats]{kruskal.test}}
}
\examples{
set.seed(123)
getPvalFisher(sample(letters[1:3], size = 100, replace = TRUE),
              sample(LETTERS[1:3], size = 100, replace = TRUE))
getPvalWilcox(rnorm(100),
              sample(LETTERS[1:2], size = 100, replace = TRUE))
}
\seealso{
Other descriptive functions: \code{\link{describeFactors}},
  \code{\link{describeMean}}, \code{\link{describeMedian}},
  \code{\link{describeProp}},
  \code{\link{getDescriptionStatsBy}}
}

