% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gitstats_functions.R
\name{set_github_host}
\alias{set_github_host}
\title{Set GitHub host}
\usage{
set_github_host(
  gitstats_object,
  host = NULL,
  token = NULL,
  orgs = NULL,
  repos = NULL,
  verbose = is_verbose(gitstats_object)
)
}
\arguments{
\item{gitstats_object}{A GitStats object.}

\item{host}{A character, optional, URL name of the host. If not passed, a
public host will be used.}

\item{token}{A token.}

\item{orgs}{An optional character vector of organisations. If you pass it,
\code{repos} parameter should stay \code{NULL}.}

\item{repos}{An optional character vector of repositories full names
(organization and repository name, e.g. "r-world-devs/GitStats"). If you
pass it, \code{orgs} parameter should stay \code{NULL}.}

\item{verbose}{A logical, \code{TRUE} by default. If \code{FALSE} messages and printing
output is switched off.}
}
\value{
A \code{GitStats} object with added information on host.
}
\description{
Set GitHub host
}
\details{
If you do not define \code{orgs} and \code{repos}, \code{GitStats} will be set to
scan whole Git platform (such as enterprise version of GitHub or GitLab),
unless it is a public platform. In case of a public one (like GitHub) you
need to define \code{orgs} or \code{repos} as scanning through all organizations may
take large amount of time.
}
\examples{
\dontrun{
my_gitstats <- create_gitstats() \%>\%
  set_github_host(
    orgs = c("r-world-devs", "openpharma", "pharmaverse")
  )
}
}
