% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_tree_thinning.R
\name{r_tree_thinning}
\alias{r_tree_thinning}
\title{Perform R-Tree Thinning}
\usage{
r_tree_thinning(
  coordinates,
  thin_dist = 10,
  trials = 10,
  all_trials = FALSE,
  space_partitioning = FALSE,
  euclidean = FALSE,
  R = 6371
)
}
\arguments{
\item{coordinates}{A matrix of coordinates to thin, with longitude and latitude.}

\item{thin_dist}{Thinning distance in kilometers.}

\item{trials}{Number of trials to run for thinning.}

\item{all_trials}{If TRUE, returns results of all attempts; if FALSE, returns the best attempt with the most points retained (default: FALSE).}

\item{space_partitioning}{A logical value indicating whether to use space partitioning.}

\item{euclidean}{Logical value indicating whether to compute the Euclidean distance (`TRUE`) or Haversine distance (`FALSE`, default).}

\item{R}{Radius of the Earth in kilometers (default: 6371 km).}
}
\value{
A logical vector indicating which points are kept in the best trial if all_trials is FALSE; otherwise, a list of logical vectors for each trial.
}
\description{
Applies the R-tree thinning algorithm on a set of coordinates.
}
\details{
If you want to use R-trees you need to install the `rtree` package from `remotes::install_github("jmestret/rtree")`. It is a modified version from \url{https://github.com/akoyabio/rtree}.
}
\examples{
if (requireNamespace("rtree", quietly = TRUE)) {
  # Generate random coordinates
  set.seed(123)
  coordinates <- matrix(runif(20, min = -180, max = 180), ncol = 2) # 10 random points

  # Perform thinning without space partitioning
  result <- r_tree_thinning(coordinates, thin_dist = 10, trials = 5)
  print(result)

  # Perform thinning with space partitioning
  result_space_part <- r_tree_thinning(coordinates, thin_dist = 10, trials = 5,
                                       space_partitioning = TRUE)
  print(result_space_part)

  # Perform thinning with euclidean distance
  result_euclidean <- r_tree_thinning(coordinates, thin_dist = 10, trials = 5, euclidean = TRUE)
  print(result_euclidean)
}
}
