% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SGAT.R
\name{solar}
\alias{solar}
\title{Solar Time and Declination}
\usage{
solar(tm)
}
\arguments{
\item{tm}{a vector of POSIXct times.}
}
\value{
A list containing the following vectors.
\item{\code{solarTime}}{the solar time (degrees)}
\item{\code{eqnTime}}{the equation of time (minutes of time)}
\item{\code{sinSolarDec}}{sine of the solar declination}
\item{\code{cosSolarDec}}{cosine of the solar declination}
}
\description{
Calculate solar time, the equation of time and solar declination
}
\details{
The solar time, the equation of time and the sine and cosine of
the solar declination are calculted for the times specified by
\code{tm} using the same methods as
\url{www.esrl.noaa.gov/gmd/grad/solcalc/}.
}
\examples{
## Current solar time
solar(Sys.time())
}
\seealso{
\code{\link{zenith}}
}

