% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertDegToMollweide.R
\name{convertDegToMollweide}
\alias{convertDegToMollweide}
\title{Converts a set of coordinates in degrees into a new set of coordinates in Mollweide coordinate system.}
\usage{
convertDegToMollweide(loc)
}
\arguments{
\item{loc}{A two column matrix of coordinates (The first column is longitude and the second column is latitude).}
}
\value{
A two column matrix of coordinates in Mollweide (https://pubs.usgs.gov/pp/1395/report.pdf) coordinate system.
}
\description{
Converts a set of coordinates in degrees into a new set of coordinates in Mollweide coordinate system.
}
\examples{
path1 <- system.file("extdata", "geoData.rda", package = "GeoAdjust")
load(path1)
locDegree <- cbind(surveyData$long, surveyData$lat)
locMoll <- convertDegToMollweide(loc = locDegree)
head(locMoll)
}
