% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportFA.R
\name{exportFA}
\alias{exportFA}
\title{Exporting a Fasta File.}
\usage{
exportFA(fa, file = NULL)
}
\arguments{
\item{fa}{fasta object}

\item{file}{Character, specifies filename/path}
}
\value{
A fasta file
}
\description{
This function exports a standard fasta file.
}
\details{
This function exports a fasta object to a standard fasta file. If no file name is given, the variable name will be used instead.
}
\examples{
 # Define here the location on HDD for the example file
   fpath <- system.file("extdata","example.fasta", package="GenomicTools.fileHandler")
 # Import the example fasta file  
   fastaFile <- importFA(file=fpath)
   newFasta <- fastaFile[1:5]
   
myfile <- file.path(tempdir(), "myLocs.fa")
   
  exportFA(newFasta, file=myfile)


}
\author{
Daniel Fischer
}
