% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_fst.R
\name{calculate_fst}
\alias{calculate_fst}
\title{Calculate FST}
\usage{
calculate_fst(
  pop1,
  pop2,
  sampled_individuals = 10,
  number_of_markers = 100,
  random_markers = FALSE
)
}
\arguments{
\item{pop1}{Population object}

\item{pop2}{Population object}

\item{sampled_individuals}{Number of individuals to base the FST upon.
Individuals are randomly drawn from each population, a lower number speeds
up calculations.}

\item{number_of_markers}{Number of markers along the chromosome used to
calculate FST metrics.}

\item{random_markers}{If TRUE, markers are randomly spaced along the
chromosome, if FALSE, markers are equidistantly spaced along the chromosome.}
}
\value{
FST value
}
\description{
The FST value between two populations is calculated, given a
number of markers. Markers are superimposed upon the (known) ancestry along
the chromosome for all sampled individuals. Markers can be chosen to be
regularly spaced, or randomly distributed.
}
\details{
Uses the function \code{wc} from the package \code{hierfstat} to
calculate the FST. The function \code{wc} computes the Weir and Cockerham
F statistic.
}
\examples{
two_populations <- simulate_admixture(
                        module = ancestry_module(),
                       migration = migration_settings(migration_rate = 0.01,
                                           population_size = c(100, 100)))

FST <- calculate_fst(pop1 = two_populations$population_1,
                     pop2 = two_populations$population_2,
                     sampled_individuals = 10,
                     number_of_markers = 100,
                     random_markers = TRUE)
}
