% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_allele_frequencies.R
\name{calculate_allele_frequencies}
\alias{calculate_allele_frequencies}
\title{Calculate allele frequencies}
\usage{
calculate_allele_frequencies(
  source_pop,
  locations = seq(0, 1, length.out = 100),
  progress_bar = FALSE
)
}
\arguments{
\item{source_pop}{Population for which to estimate allele frequencies}

\item{locations}{A vector indicating the locations (in Morgan) where
to calculate the allele frequencies.}

\item{progress_bar}{Displays a progress_bar if TRUE. Default value is TRUE}
}
\value{
A tibble containing the allele frequencies
}
\description{
Calculate for a number of regularly spaced markers the relative
frequency of each ancestor in the population.
}
\details{
Markers are equidistantly spaced, with a distance of
\code{step_size} in between them.
}
\examples{
number_founders = 20
wildpop =  simulate_admixture(
   module = ancestry_module(number_of_founders = 20, morgan = 1),
   pop_size = 1000,
   total_runtime = 10,
   num_threads = 1)

freq_output <- calculate_allele_frequencies(wildpop,
                                            progress_bar = TRUE)

require(ggplot2)
ggplot(freq_output, aes(x=location, y = frequency,
                        col = as.factor(ancestor))) +
  geom_line()
}
