detach("package:GeneralizedHyperbolic")
detach("package:HyperbolicDist")
library(GeneralizedHyperbolic)
gParam <- c(1, 2, 1.5, 1)
hParam <- hyperbChangePars(2, 1, gParam, noNames = TRUE)
hParam <- c(hParam[3], hParam[4], hParam[2], hParam[1])
sampleInput <- rhyperb(100, param = gParam)
gdResult <- dhyperb(sampleInput, param = gParam)
gpResult <- phyperb(seq(-2, 5, 0.2), param = gParam)
gqResult <- qhyperb(seq(0.1, 0.9, 0.1), param = gParam)
detach("package:GeneralizedHyperbolic")
library(HyperbolicDist)
hdResult <- dhyperb(sampleInput, Theta = hParam)
hpResult <- phyperb(seq(-2, 5, 0.2), Theta = hParam)
hqResult <- qhyperb(seq(0.1, 0.9, 0.1), Theta = hParam)
detach("package:HyperbolicDist")

checkEqual(gdResult, hdResult, "dhyperb")
checkEqual(gpResult, hpResult, "phyperb")
checkEqual(gqResult, hqResult, "qhyperb")
