% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylotree_class.R
\name{phylotree_to_B}
\alias{phylotree_to_B}
\title{Get B matrix from \code{Phylotree} object.}
\usage{
phylotree_to_B(phylotree)
}
\arguments{
\item{phylotree}{A \code{Phylotree} class object.}
}
\value{
A \code{data.frame} representing the B matrix of the phylogenetic tree.
}
\description{
This function retrieves the B matrix of a \code{Phylotree} object.
}
\examples{
# Get the B matrix of a tumor instance
# composed by 10 subpopulations of
# clones
B <- create_instance(
       n = 10, 
       m = 4, 
       k = 1, 
       selection = "neutral")$B

# Create a new 'Phylotree' object
# on the basis of the B matrix
phylotree <- B_to_phylotree(B)

# Get the B matrix of the phyotree
b1 <- phylotree_to_B(phylotree)
}
