% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compiled_code_gamabiomd.R
\name{generate_heatmaps}
\alias{generate_heatmaps}
\title{Generate Heatmaps}
\usage{
generate_heatmaps(
  average_percent_similarity,
  html_title = "Heatmap of Average Similarity",
  tiff_title = "Heatmap of Average Similarity",
  xlab = "SampleID",
  ylab = "SampleID",
  width_inch = 8,
  height_inch = 6,
  dpi = 300
)
}
\arguments{
\item{average_percent_similarity}{A matrix containing average similarity values between SampleIDs.
Rows and columns should be labeled with SampleIDs.}

\item{html_title}{Title for the interactive heatmap (HTML version).}

\item{tiff_title}{Title for the static heatmap (TIFF version).}

\item{xlab}{Label for the x-axis.}

\item{ylab}{Label for the y-axis.}

\item{width_inch}{Width of the heatmap in inches.}

\item{height_inch}{Height of the heatmap in inches.}

\item{dpi}{Dots per inch for the static heatmap.}
}
\value{
A list containing the file names of the generated heatmaps.
}
\description{
This function generates interactive and static heatmaps based on the average similarity matrix.
}
\examples{
\donttest{
accession_ranges <- list(
  SRU1 = "AJ240966 to AJ240970",
  STU2 = "AB015240 to AB015245",
  WPU13 = "L11934 to L11939",
  INU20 = c("AF277467 to AF277470", "AF333080 to AF333085")
)

# Use the function to expand accession ranges
sam_acc <- expand_accession_ranges(accession_ranges)
print(sam_acc)

# 2 get_sequence_information
accessions_to_query <- sam_acc$accession
seq_info <- get_sequence_information(accessions_to_query, remove_dot_1 = TRUE)
print(seq_info)
result <- preprocess_for_alignment(sam_acc, seq_info)

# Access the resulting data frames
merged_data <- result$merged_data
main_data <- result$main_data
final_data <- result$final_data

# If you want to sample 10\% from each SampleID group:
sampled_data <- data_sampling(final_data, sample_proportion = 0.1)

alignment_results <- alignment_info(final_data, type = "global", verbose = 1)

# Access the resulting data frames
score_matrix <- alignment_results$score_matrix
normalized_score_matrix <- alignment_results$normalized_score_matrix

total_aligned_positions_matrix <- alignment_results$total_aligned_positions_matrix
number_of_matching_positions_matrix <- alignment_results$number_of_matching_positions_matrix

percent_similarity_matrix <- alignment_results$percent_similarity_matrix

alignment_results_list <- alignment_results$alignment_results_list

alignment_info_matrix <- alignment_results$alignment_info_matrix

output_directory <- tempdir()

# Save the list of alignment results to an RDS file
saveRDS(alignment_results_list, file.path(output_directory, "alignment_results_list.rds"))

# Save matrices to files
write.table(score_matrix, file.path(output_directory, "score_matrix.txt"), sep = "\t")
average_percent_similarity <- compute_average_similarity_matrix(percent_similarity_matrix)
print(average_percent_similarity)

output_directory <- tempdir()
width_inch <- 8
height_inch <- 6
dpi <- 300

heatmap_files <- generate_heatmaps(average_percent_similarity)

# Save the interactive heatmap as an HTML file ####
html <- file.path(output_directory, "5. heatmap.html")
# htmlwidgets should be installed and loaded
# htmlwidgets::saveWidget(heatmap_files$html, file = html)

# save the TIFFE images ####

# heatmap_tiff_file1
tiff1 <- file.path(output_directory, "5. heatmap1.tiff")
tiff(tiff1, width = width_inch, height = height_inch, units = "in", res = dpi)
heatmap(as.matrix(average_percent_similarity), main = "Heatmap of Average Similarity")

# Close the TIFF device
dev.off()

# heatmap_tiff_file2
tiff2 <- file.path(output_directory, "5. heatmap2.tiff")

# Open the TIFF device
tiff(tiff2, width = width_inch, height = height_inch, units = "in", res = dpi)
print(heatmap_files$tiff2)

# Close the TIFF device
dev.off()

# heatmap_tiff_file3
# tiff3 <- file.path(output_directory, "5. heatmap3.tiff")

# Open the TIFF device and create the heatmap.2 with hierarchical clustering dendrogram
# gplots should be installed and loaded
# gplots::heatmap.2(as.matrix(average_percent_similarity),
#          dendrogram = "row",
#          Colv = "Rowv",
#          scale = "row",
#          main = "Heatmap of Average Similarity")

# Close the TIFF device
# dev.off()
}
}
