% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWPR.moran.test.R
\name{GWPR.moran.test}
\alias{GWPR.moran.test}
\title{Moran's I Test for Panel Regression}
\usage{
GWPR.moran.test(plm_model, SDF, bw, adaptive = FALSE, p = 2,
                       kernel = "bisquare", longlat = FALSE, alternative = "greater")
}
\arguments{
\item{plm_model}{An object of class inheriting from "plm", see plm}

\item{SDF}{Spatial*DataFrame on which is based the data, with the "ID" in the index}

\item{bw}{The optimal bandwidth, either adaptive or fixed distance}

\item{adaptive}{If TRUE, adaptive distance bandwidth is used, otherwise, fixed distance bandwidth.}

\item{p}{The power of the Minkowski distance, default is 2, i.e. the Euclidean distance}

\item{kernel}{bisquare: wgt = (1-(vdist/bw)^2)^2 if vdist < bw, wgt=0 otherwise (default);
gaussian: wgt = exp(-.5*(vdist/bw)^2);
exponential: wgt = exp(-vdist/bw);
tricube: wgt = (1-(vdist/bw)^3)^3 if vdist < bw, wgt=0 otherwise;
boxcar: wgt=1 if dist < bw, wgt=0 otherwise}

\item{longlat}{If TRUE, great circle distances will be calculated}

\item{alternative}{A character string specifying the alternative hypothesis, must be one of greater (default), less or two.sided.}
}
\value{
A list of result:
\describe{
\item{statistic}{the value of the standard deviate of Moran's I.}
\item{p.value}{the p-value of the test.}
\item{Estimated.I}{the value of the observed Moran's I.}
\item{Excepted.I}{the value of the expectation of Moran's I.}
\item{V2}{the value of the variance of Moran's I.}
\item{alternative}{a character string describing the alternative hypothesis.}
}
}
\description{
Moran's I test for spatial autocorrelation in residuals from
             an estimated panel linear model (plm).
}
\note{
: Current version of panel Moran's I test can only chech the balanced panel data.
}
\examples{
data(TransAirPolCalif)
data(California)
formula.GWPR <- pm25 ~ co2_mean + Developed_Open_Space_perc + Developed_Low_Intensity_perc +
   Developed_Medium_Intensity_perc + Developed_High_Intensity_perc +
   Open_Water_perc + Woody_Wetlands_perc + Emergent_Herbaceous_Wetlands_perc +
   Deciduous_Forest_perc + Evergreen_Forest_perc + Mixed_Forest_perc +
   Shrub_perc + Grassland_perc + Pasture_perc + Cultivated_Crops_perc +
   pop_density + summer_tmmx + winter_tmmx + summer_rmax + winter_rmax

pdata <- plm::pdata.frame(TransAirPolCalif, index = c("GEOID", "year"))
moran.plm.model <- plm::plm(formula = formula.GWPR, data = pdata, model = "within")
summary(moran.plm.model)

#precomputed bandwidth
bw.AIC.Fix <- 2.010529

# moran's I test
GWPR.moran.test(moran.plm.model, SDF = California, bw = bw.AIC.Fix, kernel = "bisquare",
                 adaptive = FALSE, p = 2, longlat = FALSE, alternative = "greater")
}
\references{
Beenstock, M., Felsenstein, D., 2019. The econometric analysis of non-stationary spatial panel data. Springer.
}
\author{
Chao Li <chaoli0394@gmail.com> Shunsuke Managi
}
