% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inpaint.R
\name{inpaint}
\alias{inpaint}
\title{Use a given dictionary D to inpaint image}
\usage{
inpaint(Y, Mask, D, L = 30, eps = NULL, sigma = 0)
}
\arguments{
\item{Y}{Each column of Y is a vectorized image patch to be denoised.}

\item{Mask}{{0,1} matrix of the same size as Y
to indicate the location of corrupted pixels.}

\item{D}{D is the dictionary used in Y=DA to inpaint.}

\item{L}{(optional) This parameter controls the maximum number of non-zero elements
in each column of sparsecolding A.}

\item{eps}{(optional) A lasso tuning paramter}

\item{sigma}{Noise level.}
}
\value{
The inpainted matrix Y.
}
\description{
Given D, obtain the sparse coding A_hat in Y=DA.
Then Y_inpaint=DA_hat.
See \url{https://arxiv.org/abs/1605.07870}
}
\examples{
I=lena_crop
## corrupt 30\% of the image
out_corrupt=AddHoles(I,0.3)
I_corrupt=out_corrupt$corruptedImage
I_mask=out_corrupt$maskImage
## split image
m=64
Y_nc = ImageSplit(I_corrupt,sqrt(m),sqrt(m));
M = ImageSplit(I_mask,sqrt(m),sqrt(m));
mu=colSums(Y_nc*M)/colSums(M)
Y=Y_nc-M*rep(mu,each=nrow(Y_nc))
mask = matrix(as.logical(M),ncol=ncol(M))
## use ODCT dictionary
D0=ODCT(64,100)
## inpaint
Y_inpaint=inpaint(Y,mask,D0)
}
