% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mi_grid.R
\name{mi.grid}
\alias{mi.grid}
\title{Calculates the mutual information of a grid type copula}
\usage{
mi.grid(gc)
}
\arguments{
\item{gc}{a grid type copula object.}
}
\value{
Returns a number with the mutual information.
}
\description{
Calculates the mutual information of a grid type copula
}
\examples{
n <- 500
x <- rgamma(n,4,1/2)
e <- rnorm(n,0,.3)
y <- sin(x+e)
Fx <- ecdf(x)
Fy <- ecdf(y)
u <- Fx(x)
v <- Fy(y)
df <- cbind(u,v)
k <- 10
m <- 10
copula.ml <- estimate.gridCopula(U = df, k = k, m = m , method = "ml")
copula.ls <- estimate.gridCopula(U=df, k=k, m=m , method = "ls")
mi.grid(gc = copula.ml)
mi.grid(gc = copula.ls)
}
