% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAGELD.R
\name{SAGELD.NullModel}
\alias{SAGELD.NullModel}
\title{Fit a SAGELD Null Model}
\usage{
SAGELD.NullModel(
  NullModel,
  UsedMethod = "SAGELD",
  PlinkFile,
  SparseGRMFile,
  PairwiseIBDFile,
  PvalueCutoff = 0.001,
  control = list()
)
}
\arguments{
\item{NullModel}{A fitted null model object from either \code{lme4::lmer()} or \code{glmmTMB::glmmTMB()}. This model should include the phenotype, environmental variable, covariates, and random effects structure.}

\item{UsedMethod}{A character string specifying the method to use. Options are "SAGELD" (default) for gene-environment interaction analysis, or "GALLOP" for analysis using only unrelated samples.}

\item{PlinkFile}{A character string specifying the path to PLINK files (without file extensions like ".bed", ".bim", or ".fam"). Used to read genotype data for calculating lambda values in gene-environment interaction models.}

\item{SparseGRMFile}{A character string specifying the path to a sparse genetic relationship matrix (GRM) file. This file should be generated using the \code{getSparseGRM()} function and contain three columns: 'ID1', 'ID2', and 'Value'.}

\item{PairwiseIBDFile}{A character string specifying the path to a pairwise identity-by-descent (IBD) file. This file should be generated using the \code{getPairwiseIBD()} function and contain five columns: 'ID1', 'ID2', 'pa', 'pb', and 'pc'.}

\item{PvalueCutoff}{A numeric value (default: 0.001) specifying the p-value cutoff for marginal genetic effect on the environmental variable. Used to filter SNPs when calculating lambda values for gene-environment interaction models.}

\item{control}{A list of control parameters for the null model fitting process. Available options include:}
}
\value{
A SAGELD null model object
}
\description{
Fit a SAGELD Null Model
}
