% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visuEq.R
\name{visuEq}
\alias{visuEq}
\title{visuEq : Displays the model Equations}
\usage{
visuEq(nVar, dMax, K, substit = 0, approx = FALSE)
}
\arguments{
\item{nVar}{The number of variables}

\item{dMax}{The maximum degree allowed for the polynomial}

\item{K}{is the model: each column corresponds to one equation
which organisation is following the convention given by function
\code{poLabs} which requires the definition of the model dimension
\code{nVar} (i.e. the number of variables) and the maximum polynomial
degree \code{dMax} allowed.}

\item{substit}{applies subtitutions:
for substit = 0 (default value), variables are chosen as X1, X2, ...
for substit = 1, variables X1, X2, ... are replaces by x,y,z, ...
for substit = 2, the codes provides a LaTex-like formulation of the model}

\item{approx}{number of digits to be used:
for approx = FALSE (default value) digits are edited with double precision 
for approx = TRUE, only the minimum number of digits is edited (in order to
have all the terms different from 0)
for approx = 1, 2, etc. then respectively 1, 2, etc. digits are added to
the minimum number of digits corresponding to approx = TRUE.}
}
\description{
Displays the model equations for a polynomial model
which description is provided as a matrix K, each column corresponding
to an equation, each equation being corresponding to a list of terms
following a convention given in `poLabs`.
}
\examples{
#EQUATIONS VISUALISATION
# number of variables:
nVar <- 3
# maximum polynomial degree:
dMax <- 2
# polynomial organization:
poLabs(nVar,dMax)
# model construction
KL = matrix(0, ncol = 3, nrow = 10)
KL[1,1] <- KL[2,2] <- 1
KL[4,1] <- -1
KL[5,3] <- -0.123456789
# Equations visualisation:
# (a) by default, variables names X1, X2, X3 are used
visuEq(nVar, dMax, KL)
# (b) for susbstit=1, variables names x, y, y are used instead
visuEq(nVar, dMax, KL, approx = TRUE, substit=1)
# (c) the name of the variables can also be chosen manualy
visuEq(nVar, dMax, KL, approx = 3, substit=c('U', 'V', 'W'))

# A canonical model can be provided as a single vector
polyTerms <- c(0.2,0,-1,0.5,0,0,0,0,0,0)
visuEq(3,2,KL)

}
\author{
Sylvain Mangiarotti
}

