% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allToTest-data.R
\docType{data}
\name{allToTest}
\alias{allToTest}
\title{This is data to be included in my package}
\format{An object of class \code{list} of length 6.}
\usage{
allToTest
}
\description{
List of 6 models to be tested by autoGPoMoTest
Each model $mToTest1, $mToTest2, etc. is provided as a matrix
of coefficients of dimension 10 * 3 that corresponds to a
formulation of three equations (nVar = 3) of maximal polynomial
degree dMax = 2. Each column column corresponds to one equation.
The order of the terms is given by \code{poLabs(nVar = 3, dMax = 2)}.
}
\examples{
###########
# example #
###########
data("allToTest")
# 6 models are available in this list:
names(allToTest)
# The parameter of their formulation (nVar and dMax)
# can be retrieved:
nVar <- dim(allToTest$mToTest6)[2]
dMax <- p2dMax(nVar = 3, pMaxKnown = dim(allToTest$mToTest6)[1])
# Their equation can be edited as follows:
visuEq(nVar, dMax, allToTest$mToTest6, approx = 2)

}
\author{
Sylvain Mangiarotti, Mireille Huc
}
\keyword{data}

