
context("corr_matrix")

test_that("check corr_matrix", {
    
    nn <- nrow(mtcars)
    x1 <- scale_norm(seq_len(nn))
    gp1 <- corr_matrix(
        X = x1,
        beta = 0.9591)
    expect_equal(
        object = dim(gp1), 
        expected = c(32L, 32L))
    expect_equal(
        object = diag(gp1), 
        expected = rep(1L, times = 32L))
    expect_equal(
        object = colSums(gp1), 
        expected = c(
            9.35709180932562, 10.3457986472257, 11.303086601339, 12.2114008432141, 
            13.0562942737269, 13.8268673814646, 14.5159536597192, 15.1200221149523, 
            15.6388199205317, 16.0748068189659, 16.4324482827806, 16.7174391021213, 
            16.9359251147607, 17.0937809312222, 17.1959886852873, 17.2461497300367, 
            17.2461497300367, 17.1959886852873, 17.0937809312222, 16.9359251147607, 
            16.7174391021213, 16.4324482827806, 16.0748068189659, 15.6388199205317, 
            15.1200221149523, 14.5159536597192, 13.8268673814646, 13.0562942737269, 
            12.2114008432141, 11.303086601339, 10.3457986472257, 9.35709180932562
        ))
    m2 <- cbind(
        x1,
        mtcars$am, 
        scale_norm(mtcars$disp))
    gp2 <- corr_matrix(
        X = m2,
        beta = c(0.9591, 0.1283, 0.8786))
    expect_equal(
        object = dim(gp2), 
        expected = c(32L, 32L))
    expect_equal(
        object = diag(gp2), 
        expected = rep(1L, times = 32L))
    expect_equal(
        object = colSums(gp2), 
        expected = c(
            3.88869784402426, 4.09466947875066, 3.85541779215921, 6.64653872899451, 
            5.23555467059183, 7.772553723519, 5.98789823536073, 7.18448283328707, 
            7.15146361457878, 7.97557306611727, 7.95194719366676, 8.59814356374667, 
            8.52881448542984, 8.39874764786718, 4.7193729856278, 5.13422394640726, 
            5.69539528675223, 5.5301377305219, 5.73382939622787, 5.88009088543588, 
            4.4432054674854, 6.60536175481063, 6.22198418547067, 5.94949017728318, 
            5.02557472052796, 6.38591200833125, 6.53820766168947, 6.27720205839307, 
            3.06797996246777, 5.71343658988558, 3.34553266816696, 5.07419103952201
        ))
})
